"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.keyForNewBackup = exports.keyForExistingBackup = undefined;

var _regenerator = require("babel-runtime/regenerator");

var _regenerator2 = _interopRequireDefault(_regenerator);

var _bluebird = require("bluebird");

var keyForExistingBackup = exports.keyForExistingBackup = function () {
    var _ref = (0, _bluebird.coroutine)( /*#__PURE__*/_regenerator2.default.mark(function _callee(backupData, password) {
        var authData;
        return _regenerator2.default.wrap(function _callee$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        if (global.Olm) {
                            _context.next = 2;
                            break;
                        }

                        throw new Error("Olm is not available");

                    case 2:
                        authData = backupData.auth_data;

                        if (!(!authData.private_key_salt || !authData.private_key_iterations)) {
                            _context.next = 5;
                            break;
                        }

                        throw new Error("Salt and/or iterations not found: " + "this backup cannot be restored with a passphrase");

                    case 5:
                        _context.next = 7;
                        return (0, _bluebird.resolve)(deriveKey(password, backupData.auth_data.private_key_salt, backupData.auth_data.private_key_iterations));

                    case 7:
                        return _context.abrupt("return", _context.sent);

                    case 8:
                    case "end":
                        return _context.stop();
                }
            }
        }, _callee, this);
    }));

    return function keyForExistingBackup(_x, _x2) {
        return _ref.apply(this, arguments);
    };
}();

var keyForNewBackup = exports.keyForNewBackup = function () {
    var _ref2 = (0, _bluebird.coroutine)( /*#__PURE__*/_regenerator2.default.mark(function _callee2(password) {
        var salt, key;
        return _regenerator2.default.wrap(function _callee2$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        if (global.Olm) {
                            _context2.next = 2;
                            break;
                        }

                        throw new Error("Olm is not available");

                    case 2:
                        salt = (0, _randomstring.randomString)(32);
                        _context2.next = 5;
                        return (0, _bluebird.resolve)(deriveKey(password, salt, DEFAULT_ITERATIONS));

                    case 5:
                        key = _context2.sent;
                        return _context2.abrupt("return", { key: key, salt: salt, iterations: DEFAULT_ITERATIONS });

                    case 7:
                    case "end":
                        return _context2.stop();
                }
            }
        }, _callee2, this);
    }));

    return function keyForNewBackup(_x3) {
        return _ref2.apply(this, arguments);
    };
}();

var deriveKey = function () {
    var _ref3 = (0, _bluebird.coroutine)( /*#__PURE__*/_regenerator2.default.mark(function _callee3(password, salt, iterations) {
        var subtleCrypto, TextEncoder, key, keybits;
        return _regenerator2.default.wrap(function _callee3$(_context3) {
            while (1) {
                switch (_context3.prev = _context3.next) {
                    case 0:
                        subtleCrypto = global.crypto.subtle;
                        TextEncoder = global.TextEncoder;

                        if (!(!subtleCrypto || !TextEncoder)) {
                            _context3.next = 4;
                            break;
                        }

                        throw new Error("Password-based backup is not avaiable on this platform");

                    case 4:
                        _context3.next = 6;
                        return (0, _bluebird.resolve)(subtleCrypto.importKey('raw', new TextEncoder().encode(password), { name: 'PBKDF2' }, false, ['deriveBits']));

                    case 6:
                        key = _context3.sent;
                        _context3.next = 9;
                        return (0, _bluebird.resolve)(subtleCrypto.deriveBits({
                            name: 'PBKDF2',
                            salt: new TextEncoder().encode(salt),
                            iterations: iterations,
                            hash: 'SHA-512'
                        }, key, global.Olm.PRIVATE_KEY_LENGTH * 8));

                    case 9:
                        keybits = _context3.sent;
                        return _context3.abrupt("return", new Uint8Array(keybits));

                    case 11:
                    case "end":
                        return _context3.stop();
                }
            }
        }, _callee3, this);
    }));

    return function deriveKey(_x4, _x5, _x6) {
        return _ref3.apply(this, arguments);
    };
}();

var _randomstring = require("../randomstring");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT_ITERATIONS = 500000; /*
                                 Copyright 2018 New Vector Ltd
                                 
                                 Licensed under the Apache License, Version 2.0 (the "License");
                                 you may not use this file except in compliance with the License.
                                 You may obtain a copy of the License at
                                 
                                     http://www.apache.org/licenses/LICENSE-2.0
                                 
                                 Unless required by applicable law or agreed to in writing, software
                                 distributed under the License is distributed on an "AS IS" BASIS,
                                 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                 See the License for the specific language governing permissions and
                                 limitations under the License.
                                 */
//# sourceMappingURL=backup_password.js.map