(function() {
  'use strict';
  // the 0.0001 offset fixes a bug in Chrome 27
  var PIx2 = Math.PI * 2 - 0.0001,
    ELLIPSE = 'Ellipse';

  /**
   * Ellipse constructor
   * @constructor
   * @augments Konva.Shape
   * @param {Object} config
   * @param {Object} config.radius defines x and y radius
   * @@shapeParams
   * @@nodeParams
   * @example
   * var ellipse = new Konva.Ellipse({
   *   radius : {
   *     x : 50,
   *     y : 50
   *   },
   *   fill: 'red'
   * });
   */
  Konva.Ellipse = function(config) {
    this.___init(config);
  };

  Konva.Ellipse.prototype = {
    _centroid: true,
    ___init: function(config) {
      // call super constructor
      Konva.Shape.call(this, config);
      this.className = ELLIPSE;
      this.sceneFunc(this._sceneFunc);
    },
    _sceneFunc: function(context) {
      var rx = this.getRadiusX(),
        ry = this.getRadiusY();

      context.beginPath();
      context.save();
      if (rx !== ry) {
        context.scale(1, ry / rx);
      }
      context.arc(0, 0, rx, 0, PIx2, false);
      context.restore();
      context.closePath();
      context.fillStrokeShape(this);
    },
    // implements Shape.prototype.getWidth()
    getWidth: function() {
      return this.getRadiusX() * 2;
    },
    // implements Shape.prototype.getHeight()
    getHeight: function() {
      return this.getRadiusY() * 2;
    },
    // implements Shape.prototype.setWidth()
    setWidth: function(width) {
      Konva.Node.prototype.setWidth.call(this, width);
      this.setRadius({
        x: width / 2
      });
    },
    // implements Shape.prototype.setHeight()
    setHeight: function(height) {
      Konva.Node.prototype.setHeight.call(this, height);
      this.setRadius({
        y: height / 2
      });
    }
  };
  Konva.Util.extend(Konva.Ellipse, Konva.Shape);

  // add getters setters
  Konva.Factory.addComponentsGetterSetter(Konva.Ellipse, 'radius', ['x', 'y']);

  /**
   * get/set radius
   * @name radius
   * @method
   * @memberof Konva.Ellipse.prototype
   * @param {Object} radius
   * @param {Number} radius.x
   * @param {Number} radius.y
   * @returns {Object}
   * @example
   * // get radius
   * var radius = ellipse.radius();
   *
   * // set radius
   * ellipse.radius({
   *   x: 200,
   *   y: 100
   * });
   */

  Konva.Factory.addGetterSetter(
    Konva.Ellipse,
    'radiusX',
    0,
    Konva.Validators.getNumberValidator()
  );
  /**
   * get/set radius x
   * @name radiusX
   * @method
   * @memberof Konva.Ellipse.prototype
   * @param {Number} x
   * @returns {Number}
   * @example
   * // get radius x
   * var radiusX = ellipse.radiusX();
   *
   * // set radius x
   * ellipse.radiusX(200);
   */

  Konva.Factory.addGetterSetter(
    Konva.Ellipse,
    'radiusY',
    0,
    Konva.Validators.getNumberValidator()
  );
  /**
   * get/set radius y
   * @name radiusY
   * @method
   * @memberof Konva.Ellipse.prototype
   * @param {Number} y
   * @returns {Number}
   * @example
   * // get radius y
   * var radiusY = ellipse.radiusY();
   *
   * // set radius y
   * ellipse.radiusY(200);
   */

  Konva.Collection.mapMethods(Konva.Ellipse);
})();
