"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Return an accessor function using the accessor passed as argument
 * @param accessor the spec accessor
 */
function getAccessorFn(accessor) {
    if (typeof accessor === 'string' || typeof accessor === 'number') {
        return function (datum) {
            return datum[accessor];
        };
    }
    if (typeof accessor === 'function') {
        return accessor;
    }
    throw new Error('Accessor must be a string or a function');
}
exports.getAccessorFn = getAccessorFn;
//# sourceMappingURL=accessor.js.map