"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var y_domain_1 = require("./domains/y_domain");
var nonstacked_series_utils_1 = require("./nonstacked_series_utils");
var series_utils_1 = require("./series_utils");
var stacked_series_utils_1 = require("./stacked_series_utils");
function findDataSeriesByColorValues(series, value) {
    if (!series) {
        return -1;
    }
    return series.findIndex(function (item) {
        return series_utils_1.isEqualSeriesKey(item.colorValues, value.colorValues) && item.specId === value.specId;
    });
}
exports.findDataSeriesByColorValues = findDataSeriesByColorValues;
/**
 * Split a dataset into multiple series, each having a key with the relative
 * series configuration
 */
function splitSeries(data, accessors, specId) {
    var xAccessor = accessors.xAccessor, yAccessors = accessors.yAccessors, y0Accessors = accessors.y0Accessors, _a = accessors.splitSeriesAccessors, splitSeriesAccessors = _a === void 0 ? [] : _a;
    var colorAccessors = accessors.colorAccessors ? accessors.colorAccessors : splitSeriesAccessors;
    var isMultipleY = yAccessors && yAccessors.length > 1;
    var series = new Map();
    var colorsValues = new Map();
    var xValues = new Set();
    var splitSeriesLastValues = new Map();
    data.forEach(function (datum) {
        var seriesKey = getAccessorsValues(datum, splitSeriesAccessors);
        if (isMultipleY) {
            yAccessors.forEach(function (accessor, index) {
                var colorValues = getColorValues(datum, colorAccessors, accessor);
                var colorValuesKey = getColorValuesAsString(colorValues, specId);
                colorsValues.set(colorValuesKey, colorValues);
                var cleanedDatum = cleanDatum(datum, xAccessor, accessor, y0Accessors && y0Accessors[index]);
                splitSeriesLastValues.set(colorValuesKey, cleanedDatum.y1);
                xValues.add(cleanedDatum.x);
                updateSeriesMap(series, __spread(seriesKey, [accessor]), cleanedDatum, specId, colorValuesKey);
            }, {});
        }
        else {
            var colorValues = getColorValues(datum, colorAccessors);
            var colorValuesKey = getColorValuesAsString(colorValues, specId);
            colorsValues.set(colorValuesKey, colorValues);
            var cleanedDatum = cleanDatum(datum, xAccessor, yAccessors[0], y0Accessors && y0Accessors[0]);
            splitSeriesLastValues.set(colorValuesKey, cleanedDatum.y1);
            xValues.add(cleanedDatum.x);
            updateSeriesMap(series, __spread(seriesKey), cleanedDatum, specId, colorValuesKey);
        }
    }, {});
    return {
        rawDataSeries: __spread(series.values()),
        colorsValues: colorsValues,
        xValues: xValues,
        splitSeriesLastValues: splitSeriesLastValues,
    };
}
exports.splitSeries = splitSeries;
/**
 * Mutate the passed map adding or updating the DataSeries stored
 * along with the series key
 */
function updateSeriesMap(seriesMap, seriesKey, datum, specId, seriesColorKey) {
    var seriesKeyString = seriesKey.join('___');
    var series = seriesMap.get(seriesKeyString);
    if (series) {
        series.data.push(datum);
    }
    else {
        seriesMap.set(seriesKeyString, {
            specId: specId,
            seriesColorKey: seriesColorKey,
            key: seriesKey,
            data: [datum],
        });
    }
    return seriesMap;
}
/**
 * Get the array of values that forms a series key
 */
function getAccessorsValues(datum, accessors) {
    if (accessors === void 0) { accessors = []; }
    return accessors
        .map(function (accessor) {
        return datum[accessor];
    })
        .filter(function (value) { return value !== undefined; });
}
/**
 * Get the array of values that forms a series key
 */
function getColorValues(datum, colorAccessors, yAccessorValue) {
    if (colorAccessors === void 0) { colorAccessors = []; }
    var colorValues = getAccessorsValues(datum, colorAccessors);
    if (yAccessorValue) {
        return __spread(colorValues, [yAccessorValue]);
    }
    return colorValues;
}
/**
 * Get the array of values that forms a series key
 */
function getColorValuesAsString(colorValues, specId) {
    return "specId:{" + specId + "},colors:{" + colorValues + "}";
}
exports.getColorValuesAsString = getColorValuesAsString;
/**
 * Reformat the datum having only the required x and y property.
 */
function cleanDatum(datum, xAccessor, yAccessor, y0Accessor) {
    var x = datum[xAccessor];
    var y1 = datum[yAccessor];
    var cleanedDatum = { x: x, y1: y1, datum: datum, y0: null };
    if (y0Accessor) {
        cleanedDatum.y0 = datum[y0Accessor];
    }
    return cleanedDatum;
}
function getFormattedDataseries(specs, dataSeries) {
    var specsByGroupIds = y_domain_1.splitSpecsByGroupId(specs);
    var specsByGroupIdsEntries = __spread(specsByGroupIds.entries());
    var stackedFormattedDataSeries = [];
    var nonStackedFormattedDataSeries = [];
    specsByGroupIdsEntries.forEach(function (_a) {
        var _b = __read(_a, 2), groupId = _b[0], groupSpecs = _b[1];
        // format stacked data series
        var stackedDataSeries = getRawDataSeries(groupSpecs.stacked, dataSeries);
        stackedFormattedDataSeries.push({
            groupId: groupId,
            counts: stackedDataSeries.counts,
            dataSeries: stacked_series_utils_1.formatStackedDataSeriesValues(stackedDataSeries.rawDataSeries, false),
        });
        // format non stacked data series
        var nonStackedDataSeries = getRawDataSeries(groupSpecs.nonStacked, dataSeries);
        nonStackedFormattedDataSeries.push({
            groupId: groupId,
            counts: nonStackedDataSeries.counts,
            dataSeries: nonstacked_series_utils_1.formatNonStackedDataSeriesValues(nonStackedDataSeries.rawDataSeries, false),
        });
    });
    return {
        stacked: stackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
        nonStacked: nonStackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
    };
}
exports.getFormattedDataseries = getFormattedDataseries;
function getRawDataSeries(seriesSpecs, dataSeries) {
    var rawDataSeries = [];
    var counts = {
        barSeries: 0,
        lineSeries: 0,
        areaSeries: 0,
    };
    var seriesSpecsCount = seriesSpecs.length;
    var i;
    for (i = 0; i < seriesSpecsCount; i++) {
        var spec = seriesSpecs[i];
        var id = spec.id, seriesType = spec.seriesType;
        var ds = dataSeries.get(id);
        switch (seriesType) {
            case 'bar':
                counts.barSeries += ds ? ds.length : 0;
                break;
            case 'line':
                counts.lineSeries += ds ? ds.length : 0;
                break;
            case 'area':
                counts.areaSeries += ds ? ds.length : 0;
                break;
        }
        if (ds) {
            rawDataSeries.push.apply(rawDataSeries, __spread(ds));
        }
    }
    return {
        rawDataSeries: rawDataSeries,
        counts: counts,
    };
}
exports.getRawDataSeries = getRawDataSeries;
function getSplittedSeries(seriesSpecs, deselectedDataSeries) {
    var e_1, _a;
    var splittedSeries = new Map();
    var seriesColors = new Map();
    var xValues = new Set();
    var _loop_1 = function (specId, spec) {
        var e_2, _a;
        var dataSeries = splitSeries(spec.data, spec, specId);
        var currentRawDataSeries = dataSeries.rawDataSeries;
        if (deselectedDataSeries) {
            currentRawDataSeries = dataSeries.rawDataSeries.filter(function (series) {
                var seriesValues = {
                    specId: specId,
                    colorValues: series.key,
                };
                return findDataSeriesByColorValues(deselectedDataSeries, seriesValues) < 0;
            });
        }
        splittedSeries.set(specId, currentRawDataSeries);
        dataSeries.colorsValues.forEach(function (colorValues, key) {
            var lastValue = dataSeries.splitSeriesLastValues.get(key);
            seriesColors.set(key, {
                specId: specId,
                specSortIndex: spec.sortIndex,
                colorValues: colorValues,
                lastValue: lastValue,
            });
        });
        try {
            for (var _b = __values(dataSeries.xValues), _c = _b.next(); !_c.done; _c = _b.next()) {
                var xValue = _c.value;
                xValues.add(xValue);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    try {
        for (var seriesSpecs_1 = __values(seriesSpecs), seriesSpecs_1_1 = seriesSpecs_1.next(); !seriesSpecs_1_1.done; seriesSpecs_1_1 = seriesSpecs_1.next()) {
            var _b = __read(seriesSpecs_1_1.value, 2), specId = _b[0], spec = _b[1];
            _loop_1(specId, spec);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (seriesSpecs_1_1 && !seriesSpecs_1_1.done && (_a = seriesSpecs_1.return)) _a.call(seriesSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return {
        splittedSeries: splittedSeries,
        seriesColors: seriesColors,
        xValues: xValues,
    };
}
exports.getSplittedSeries = getSplittedSeries;
function getSortedDataSeriesColorsValuesMap(colorValuesMap) {
    var seriesColorsArray = __spread(colorValuesMap);
    seriesColorsArray.sort(function (seriesA, seriesB) {
        var _a = __read(seriesA, 2), colorValuesA = _a[1];
        var _b = __read(seriesB, 2), colorValuesB = _b[1];
        var specAIndex = colorValuesA.specSortIndex != null ? colorValuesA.specSortIndex : colorValuesMap.size;
        var specBIndex = colorValuesB.specSortIndex != null ? colorValuesB.specSortIndex : colorValuesMap.size;
        return specAIndex - specBIndex;
    });
    return new Map(__spread(seriesColorsArray));
}
exports.getSortedDataSeriesColorsValuesMap = getSortedDataSeriesColorsValuesMap;
function getSeriesColorMap(seriesColors, chartColors, customColors) {
    var seriesColorMap = new Map();
    var counter = 0;
    seriesColors.forEach(function (value, seriesColorKey) {
        var customSeriesColor = customColors.get(seriesColorKey);
        var color = customSeriesColor || chartColors.vizColors[counter % chartColors.vizColors.length];
        seriesColorMap.set(seriesColorKey, color);
        counter++;
    });
    return seriesColorMap;
}
exports.getSeriesColorMap = getSeriesColorMap;
//# sourceMappingURL=series.js.map