/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeVar {
    private String name;
    private ArgType type;
    private List<SSAVar> ssaVars = new ArrayList<SSAVar>(3);
    private boolean isFinal;
    private boolean isThis;
    private boolean isDeclared;

    public static CodeVar fromMthArg(RegisterArg mthArg) {
        CodeVar var = new CodeVar();
        var.setType(mthArg.getInitType());
        var.setName(mthArg.getName());
        var.setDeclared(true);
        var.setThis(mthArg.isThis());
        var.setSsaVars(Collections.singletonList(new SSAVar(mthArg.getRegNum(), 0, mthArg)));
        return var;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArgType getType() {
        return this.type;
    }

    public void setType(ArgType type) {
        this.type = type;
    }

    public List<SSAVar> getSsaVars() {
        return this.ssaVars;
    }

    public void addSsaVar(SSAVar ssaVar) {
        if (!this.ssaVars.contains(ssaVar)) {
            this.ssaVars.add(ssaVar);
        }
    }

    public void setSsaVars(List<SSAVar> ssaVars) {
        this.ssaVars = ssaVars;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setThis(boolean aThis) {
        this.isThis = aThis;
    }

    public boolean isDeclared() {
        return this.isDeclared;
    }

    public void setDeclared(boolean declared) {
        this.isDeclared = declared;
    }

    public void mergeFlagsFrom(CodeVar other) {
        if (other.isDeclared()) {
            this.setDeclared(true);
        }
        if (other.isThis()) {
            this.setThis(true);
        }
        if (other.isFinal()) {
            this.setFinal(true);
        }
    }

    public String toString() {
        return (this.isFinal ? "final " : "") + this.type + ' ' + this.name;
    }
}

