/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.diagnostics;

import org.gradle.internal.remote.Address;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;

public class DaemonStartupInfo {
    private final String uid;
    private final Address address;
    private final DaemonDiagnostics diagnostics;

    public DaemonStartupInfo(String uid, Address address, DaemonDiagnostics diagnostics) {
        this.uid = uid;
        this.address = address;
        this.diagnostics = diagnostics;
    }

    public String getUid() {
        return this.uid;
    }

    public Address getAddress() {
        return this.address;
    }

    public Long getPid() {
        return this.diagnostics.getPid();
    }

    public DaemonDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public String toString() {
        return String.format("DaemonStartupInfo{pid=%s, uid=%s, address=%s, diagnostics=%s}", this.diagnostics.getPid(), this.uid, this.address, this.diagnostics);
    }

    public String describe() {
        if (this.diagnostics == null) {
            return "Daemon uid: " + this.uid + " without diagnostics.";
        }
        return "Daemon uid: " + this.uid + " with diagnostics:\n" + this.diagnostics.describe();
    }
}

