/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.EnumValueSnapshot;

public class IsolatedEnumValueSnapshot
extends EnumValueSnapshot
implements Isolatable<Enum> {
    private final Enum<?> value;

    public IsolatedEnumValueSnapshot(Enum<?> value) {
        super(value);
        this.value = value;
    }

    public ValueSnapshot asSnapshot() {
        return new EnumValueSnapshot(this.value);
    }

    public Enum isolate() {
        return this.value;
    }

    @Nullable
    public <S> S coerce(Class<S> type) {
        if (type.isAssignableFrom(this.value.getClass())) {
            return type.cast(this.value);
        }
        if (type.isEnum() && type.getName().equals(this.value.getClass().getName())) {
            return type.cast(Enum.valueOf(type.asSubclass(Enum.class), this.value.name()));
        }
        return null;
    }
}

