/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.AsmBackedClassGenerator;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.instantiation.DefaultInstantiationScheme;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.Jsr330ConstructorSelector;
import org.gradle.internal.instantiation.ManagedTypeFactory;
import org.gradle.internal.instantiation.ParamsMatchingConstructorSelector;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.ManagedFactory;

public class DefaultInstantiatorFactory
implements InstantiatorFactory {
    private static final int MANAGED_FACTORY_ID = Objects.hashCode(ClassGeneratorBackedManagedFactory.class.getName());
    private final ServiceRegistry defaultServices;
    private final CrossBuildInMemoryCacheFactory cacheFactory;
    private final List<InjectAnnotationHandler> annotationHandlers;
    private final DefaultInstantiationScheme injectOnlyScheme;
    private final DefaultInstantiationScheme injectOnlyLenientScheme;
    private final DefaultInstantiationScheme decoratingScheme;
    private final DefaultInstantiationScheme decoratingLenientScheme;
    private final ManagedFactory managedFactory;

    public DefaultInstantiatorFactory(CrossBuildInMemoryCacheFactory cacheFactory, List<InjectAnnotationHandler> annotationHandlers) {
        this.cacheFactory = cacheFactory;
        this.annotationHandlers = annotationHandlers;
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(InstantiatorFactory.class, (Object)this);
        this.defaultServices = services;
        ClassGenerator injectOnly = AsmBackedClassGenerator.injectOnly(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of(), cacheFactory, MANAGED_FACTORY_ID);
        ClassGenerator decorated = AsmBackedClassGenerator.decorateAndInject(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of(), cacheFactory, MANAGED_FACTORY_ID);
        this.managedFactory = new ClassGeneratorBackedManagedFactory(injectOnly);
        Jsr330ConstructorSelector injectOnlyJsr330Selector = new Jsr330ConstructorSelector(injectOnly, cacheFactory.newClassCache());
        Jsr330ConstructorSelector decoratedJsr330Selector = new Jsr330ConstructorSelector(decorated, cacheFactory.newClassCache());
        ParamsMatchingConstructorSelector injectOnlyLenientSelector = new ParamsMatchingConstructorSelector(injectOnly, cacheFactory.newClassCache());
        ParamsMatchingConstructorSelector decoratedLenientSelector = new ParamsMatchingConstructorSelector(decorated, cacheFactory.newClassCache());
        this.injectOnlyScheme = new DefaultInstantiationScheme((ConstructorSelector)injectOnlyJsr330Selector, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class), cacheFactory);
        this.injectOnlyLenientScheme = new DefaultInstantiationScheme((ConstructorSelector)injectOnlyLenientSelector, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class), cacheFactory);
        this.decoratingScheme = new DefaultInstantiationScheme((ConstructorSelector)decoratedJsr330Selector, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class), cacheFactory);
        this.decoratingLenientScheme = new DefaultInstantiationScheme((ConstructorSelector)decoratedLenientSelector, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class), cacheFactory);
    }

    @Override
    public Instantiator inject(ServiceLookup services) {
        return this.injectOnlyScheme.withServices(services).instantiator();
    }

    @Override
    public Instantiator inject() {
        return this.injectOnlyScheme.instantiator();
    }

    @Override
    public InstantiationScheme injectScheme() {
        return this.injectOnlyScheme;
    }

    @Override
    public InstantiationScheme injectScheme(Collection<Class<? extends Annotation>> injectAnnotations) {
        if (injectAnnotations.isEmpty()) {
            return this.injectOnlyScheme;
        }
        for (Class<? extends Annotation> annotation : injectAnnotations) {
            this.assertKnownAnnotation(annotation);
        }
        ClassGenerator classGenerator = AsmBackedClassGenerator.injectOnly(this.annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.copyOf(injectAnnotations), this.cacheFactory, MANAGED_FACTORY_ID);
        Jsr330ConstructorSelector constructorSelector = new Jsr330ConstructorSelector(classGenerator, this.cacheFactory.newClassCache());
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(injectAnnotations.size() + 1));
        builder.addAll(injectAnnotations);
        builder.add(Inject.class);
        return new DefaultInstantiationScheme((ConstructorSelector)constructorSelector, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)builder.build(), this.cacheFactory);
    }

    @Override
    public Instantiator injectLenient() {
        return this.injectOnlyLenientScheme.instantiator();
    }

    @Override
    public Instantiator injectLenient(ServiceLookup services) {
        return this.injectOnlyLenientScheme.withServices(services).instantiator();
    }

    @Override
    public Instantiator decorateLenient() {
        return this.decoratingLenientScheme.instantiator();
    }

    @Override
    public Instantiator injectAndDecorateLenient(ServiceLookup services) {
        return this.decoratingLenientScheme.withServices(services).instantiator();
    }

    @Override
    public InstantiationScheme decorateScheme() {
        return this.decoratingScheme;
    }

    @Override
    public Instantiator injectAndDecorate(ServiceLookup services) {
        return this.decoratingScheme.withServices(services).instantiator();
    }

    @Override
    public ManagedFactory getManagedFactory() {
        return this.managedFactory;
    }

    private void assertKnownAnnotation(Class<? extends Annotation> annotation) {
        for (InjectAnnotationHandler annotationHandler : this.annotationHandlers) {
            if (!annotationHandler.getAnnotationType().equals(annotation)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Annotation @%s is not a registered injection annotation.", annotation.getSimpleName()));
    }

    private static class ClassGeneratorBackedManagedFactory
    implements ManagedFactory {
        private final ClassGenerator classGenerator;

        public ClassGeneratorBackedManagedFactory(ClassGenerator classGenerator) {
            this.classGenerator = classGenerator;
        }

        @Override
        @Nullable
        public <T> T fromState(Class<T> type, Object state) {
            Class<T> generatedClass = this.classGenerator.generate(type).getGeneratedClass();
            return new ManagedTypeFactory(generatedClass).fromState(type, state);
        }

        @Override
        public int getId() {
            return MANAGED_FACTORY_ID;
        }
    }
}

