define(["browser","appStorage","apphost","loading","connectionManager","globalize","appRouter","dom","css!./multiselect"],function(browser,appStorage,appHost,loading,connectionManager,globalize,appRouter,dom){"use strict";var currentSelectionCommandsPanel,selectedItems=[],selectedElements=[];function hideSelections(){var selectionCommandsPanel=currentSelectionCommandsPanel;if(selectionCommandsPanel){selectionCommandsPanel.parentNode.removeChild(selectionCommandsPanel),currentSelectionCommandsPanel=null,selectedItems=[],selectedElements=[];for(var elems=document.querySelectorAll(".itemSelectionPanel"),i=0,length=elems.length;i<length;i++){var parent=elems[i].parentNode;parent.removeChild(elems[i]),parent.classList.remove("withMultiSelect")}}}function updateItemSelection(chkItemSelect,selected){var id=dom.parentWithAttribute(chkItemSelect,"data-id").getAttribute("data-id");selected?selectedItems.filter(function(i){return i===id}).length||(selectedItems.push(id),selectedElements.push(chkItemSelect)):(selectedItems=selectedItems.filter(function(i){return i!==id}),selectedElements=selectedElements.filter(function(i){return i!==chkItemSelect}));if(selectedItems.length){var itemSelectionCount=document.querySelector(".itemSelectionCount");itemSelectionCount&&(itemSelectionCount.innerHTML=selectedItems.length)}else hideSelections()}function onSelectionChange(e){updateItemSelection(this,this.checked)}function showSelection(item,isChecked){var itemSelectionPanel=item.querySelector(".itemSelectionPanel");if(!itemSelectionPanel){(itemSelectionPanel=document.createElement("div")).classList.add("itemSelectionPanel");var parent=item.querySelector(".cardBox")||item.querySelector(".cardContent");parent.classList.add("withMultiSelect"),parent.appendChild(itemSelectionPanel);var checkedAttribute=isChecked?" checked":"";itemSelectionPanel.innerHTML='<label class="checkboxContainer"><input type="checkbox" is="emby-checkbox" data-outlineclass="multiSelectCheckboxOutline" class="chkItemSelect"'+checkedAttribute+"/><span></span></label>",itemSelectionPanel.querySelector(".chkItemSelect").addEventListener("change",onSelectionChange)}}function deleteItems(apiClient,itemIds){return new Promise(function(resolve,reject){var msg=globalize.translate("ConfirmDeleteItem"),title=globalize.translate("HeaderDeleteItem");1<itemIds.length&&(msg=globalize.translate("ConfirmDeleteItems"),title=globalize.translate("HeaderDeleteItems")),msg+="\n\n"+globalize.translate("AreYouSureToContinue"),require(["confirm"],function(confirm){confirm(msg,title).then(function(){var promises=itemIds.map(function(itemId){apiClient.deleteItem(itemId)});Promise.all(promises).then(resolve,function(){(function(options){return new Promise(function(resolve,reject){require(["alert"],function(alert){alert(options).then(resolve,resolve)})})})(globalize.translate("ErrorDeletingItem")).then(reject,reject)})},reject)})})}function showMenuForSelectedItems(e){var apiClient=connectionManager.currentApiClient();apiClient.getCurrentUser().then(function(user){var menuItems=[];menuItems.push({name:globalize.translate("AddToCollection"),id:"addtocollection",ironIcon:"add"}),menuItems.push({name:globalize.translate("AddToPlaylist"),id:"playlist",ironIcon:"playlist-add"}),user.Policy.EnableContentDeletion&&menuItems.push({name:globalize.translate("Delete"),id:"delete",ironIcon:"delete"}),user.Policy.EnableContentDownloading&&appHost.supports("filedownload"),user.Policy.EnableContentDownloading&&appHost.supports("sync")&&menuItems.push({name:globalize.translate("Download"),id:"synclocal"}),menuItems.push({name:globalize.translate("GroupVersions"),id:"groupvideos",ironIcon:"call-merge"}),menuItems.push({name:globalize.translate("MarkPlayed"),id:"markplayed"}),menuItems.push({name:globalize.translate("MarkUnplayed"),id:"markunplayed"}),menuItems.push({name:globalize.translate("RefreshMetadata"),id:"refresh"}),user.Policy.EnableContentDownloading&&menuItems.push({name:globalize.translate("Sync"),id:"sync"}),require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,positionTo:e.target,callback:function(id){var items=selectedItems.slice(0),serverId=apiClient.serverInfo().Id;switch(id){case"addtocollection":require(["collectionEditor"],function(collectionEditor){(new collectionEditor).show({items:items,serverId:serverId})}),hideSelections();break;case"playlist":require(["playlistEditor"],function(playlistEditor){(new playlistEditor).show({items:items,serverId:serverId})}),hideSelections();break;case"delete":deleteItems(apiClient,items).then(dispatchNeedsRefresh),hideSelections();break;case"groupvideos":!function(apiClient,selection){if(selection.length<2)return require(["alert"],function(alert){alert({text:globalize.translate("PleaseSelectTwoItems")})});loading.show(),apiClient.ajax({type:"POST",url:apiClient.getUrl("Videos/MergeVersions",{Ids:selection.join(",")})}).then(function(){loading.hide(),dispatchNeedsRefresh(),hideSelections()},function(){loading.hide(),hideSelections()})}(apiClient,items);break;case"markplayed":items.forEach(function(itemId){apiClient.markPlayed(apiClient.getCurrentUserId(),itemId)}),hideSelections();break;case"markunplayed":items.forEach(function(itemId){apiClient.markUnplayed(apiClient.getCurrentUserId(),itemId)}),hideSelections();break;case"refresh":require(["refreshDialog"],function(refreshDialog){new refreshDialog({itemIds:items,serverId:serverId}).show()}),hideSelections();break;case"sync":require(["syncDialog"],function(syncDialog){syncDialog.showMenu({items:items.map(function(i){return{Id:i}}),serverId:serverId})}),hideSelections();break;case"synclocal":require(["syncDialog"],function(syncDialog){syncDialog.showMenu({items:items.map(function(i){return{Id:i}}),isLocalSync:!0,serverId:serverId})}),hideSelections()}}})})})}function dispatchNeedsRefresh(){var i,length,elems=[],selectedElems=selectedElements;for(i=0,length=selectedElems.length;i<length;i++){var selectedElem=selectedElems[i],container=dom.parentWithAttribute(selectedElem,"is","emby-itemscontainer");container&&-1===elems.indexOf(container)&&elems.push(container)}for(i=0,length=elems.length;i<length;i++)elems[i].notifyRefreshNeeded(!0)}function showSelections(initialCard){require(["emby-checkbox"],function(){for(var cards=document.querySelectorAll(".card"),i=0,length=cards.length;i<length;i++)showSelection(cards[i],initialCard===cards[i]);!function(){var selectionCommandsPanel=currentSelectionCommandsPanel;if(!selectionCommandsPanel){(selectionCommandsPanel=document.createElement("div")).classList.add("selectionCommandsPanel"),document.body.appendChild(selectionCommandsPanel);'<button is="paper-icon-button-light" class="btnCloseSelectionPanel autoSize"><i class="md-icon">close</i></button>','<h1 class="itemSelectionCount"></h1>';'<button is="paper-icon-button-light" class="btnSelectionPanelOptions autoSize" style="margin-left:auto;"><i class="md-icon">&#xE5D3;</i></button>',(currentSelectionCommandsPanel=selectionCommandsPanel).innerHTML='<button is="paper-icon-button-light" class="btnCloseSelectionPanel autoSize"><i class="md-icon">close</i></button><h1 class="itemSelectionCount"></h1><button is="paper-icon-button-light" class="btnSelectionPanelOptions autoSize" style="margin-left:auto;"><i class="md-icon">&#xE5D3;</i></button>',selectionCommandsPanel.querySelector(".btnCloseSelectionPanel").addEventListener("click",hideSelections);var btnSelectionPanelOptions=selectionCommandsPanel.querySelector(".btnSelectionPanelOptions");dom.addEventListener(btnSelectionPanelOptions,"click",showMenuForSelectedItems,{passive:!0})}}(),updateItemSelection(initialCard,!0)})}function onContainerClick(e){var target=e.target;if(selectedItems.length){var card=dom.parentWithClass(target,"card");if(card){var itemSelectionPanel=card.querySelector(".itemSelectionPanel");if(itemSelectionPanel)return function(e,itemSelectionPanel){var chkItemSelect=dom.parentWithClass(e.target,"chkItemSelect");if(chkItemSelect=chkItemSelect||itemSelectionPanel.querySelector(".chkItemSelect")){var newValue=!chkItemSelect.checked;chkItemSelect.checked=newValue,updateItemSelection(chkItemSelect,newValue)}return e.preventDefault(),e.stopPropagation(),!1}(e,itemSelectionPanel)}return e.preventDefault(),e.stopPropagation(),!1}}return document.addEventListener("viewbeforehide",hideSelections),function(options){var container=options.container;!1!==options.bindOnClick&&container.addEventListener("click",onContainerClick),this.showSelections=showSelections,this.onContainerClick=onContainerClick,this.destroy=function(){container.removeEventListener("click",onContainerClick)}}});