/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.internal.ui.WorkingDirectoryBlock;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class CAbstractArgumentsTab
extends CLaunchConfigurationTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected Button fArgumentVariablesButton;
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = new WorkingDirectoryBlock();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_arguments_tab");
        this.createArgumentComponent(comp, 1);
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void createArgumentComponent(Composite comp, int horizontalSpan) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setFont(font);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = horizontalSpan;
        group.setLayoutData((Object)gd);
        group.setText(LaunchMessages.CArgumentsTab_C_Program_Arguments);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        this.fPrgmArgumentsText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchMessages.CArgumentsTab_C_Program_Arguments;
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CAbstractArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fArgumentVariablesButton = this.createVariablesButton((Composite)group, LaunchMessages.CArgumentsTab_Variables, this.fPrgmArgumentsText);
        gd = new GridData(128);
        this.fArgumentVariablesButton.setLayoutData((Object)gd);
        this.addControlAccessibleListener((Control)this.fArgumentVariablesButton, this.fArgumentVariablesButton.getText());
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        config.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)LaunchMessages.Launch_common_Exception_occurred_reading_configuration_EXCEPTION, (Object)e.getStatus().getMessage()));
            LaunchUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (!(content = content.replaceAll("\r\n", "\n")).isEmpty()) {
            return content;
        }
        return null;
    }

    public abstract String getId();

    public String getName() {
        return LaunchMessages.CArgumentsTab_Arguments;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ARGUMENTS_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

