/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceCaptureDialog
extends Dialog {
    private static final URI INSTANCE_URI = URI.createURI((String)"//instance");
    protected ILabelProvider labelProvider;
    protected FilteringAdapterFactoryContentProvider availablePreferencesContentProvider;
    protected FilteringAdapterFactoryContentProvider selectedPreferencesContentProvider;
    protected Set<Object> included = new HashSet<Object>();
    protected boolean fromEclipsePreferenceFile;

    public PreferenceCaptureDialog(Shell parent, AdapterFactory adapterFactory, boolean fromEclipsePreferenceFile) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fromEclipsePreferenceFile = fromEclipsePreferenceFile;
        this.labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        this.availablePreferencesContentProvider = new FilteringAdapterFactoryContentProvider(adapterFactory, false);
        this.selectedPreferencesContentProvider = new FilteringAdapterFactoryContentProvider(adapterFactory, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fromEclipsePreferenceFile ? "Import Preferences" : "Capture Preferences");
        shell.setImage(SetupEditorPlugin.INSTANCE.getSWTImage(this.fromEclipsePreferenceFile ? "preference_importer" : "preference_picker"));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SetupEditorPlugin.INSTANCE.getDialogSettings(this.fromEclipsePreferenceFile ? "PreferenceImport" : "PreferenceCapture");
    }

    protected List<?> getAvailablePreferences() {
        PreferenceNode rootPreferenceNode = PreferencesUtil.getRootPreferenceNode(Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("bundle_defaults", "default", "instance"))), (boolean)false);
        HashMap<URI, Pair<String, String>> preferences = new HashMap<URI, Pair<String, String>>();
        for (PreferenceNode preferenceNode : rootPreferenceNode.getChildren()) {
            this.traverse(preferences, preferenceNode);
        }
        return RecorderTransaction.record(preferences);
    }

    protected void traverse(Map<URI, Pair<String, String>> preferences, PreferenceNode preferenceNode) {
        for (PreferenceNode childPreferenceNode : preferenceNode.getChildren()) {
            this.traverse(preferences, childPreferenceNode);
        }
        for (Property property : preferenceNode.getProperties()) {
            preferences.put(INSTANCE_URI.appendSegments(property.getRelativePath().segments()), (Pair<String, String>)new Pair(null, (Object)property.getValue()));
        }
    }

    protected Control createDialogArea(Composite parent) {
        final ItemProvider input = new ItemProvider();
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Text preferenceFileText = null;
        if (this.fromEclipsePreferenceFile) {
            Group preferenceFileGroup = new Group(contents, 0);
            preferenceFileGroup.setText("Eclipse Preference File");
            preferenceFileGroup.setLayout((Layout)new GridLayout(2, false));
            preferenceFileGroup.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            final Text finalPreferenceFileText = preferenceFileText = new Text((Composite)preferenceFileGroup, 2048);
            preferenceFileText.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
            Button preferenceFileBrowseButton = new Button((Composite)preferenceFileGroup, 8);
            preferenceFileBrowseButton.setText("Browse...");
            preferenceFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(PreferenceCaptureDialog.this.getShell(), 4098);
                    dialog.setFilterExtensions(new String[]{"*.epf"});
                    String result = dialog.open();
                    if (result != null) {
                        finalPreferenceFileText.setText(result);
                    }
                }
            });
        }
        Group filterGroupComposite = new Group(contents, 0);
        filterGroupComposite.setText("Filter Available Preferences");
        filterGroupComposite.setLayout((Layout)new GridLayout(1, false));
        filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        Composite availablePreferencesComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        availablePreferencesComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        availablePreferencesComposite.setLayout((Layout)layout);
        Label availablePreferencesLabel = new Label(availablePreferencesComposite, 0);
        availablePreferencesLabel.setText("Available Preferences");
        GridData availablePreferencesLabelGridData = new GridData();
        availablePreferencesLabelGridData.verticalAlignment = 4;
        availablePreferencesLabelGridData.horizontalAlignment = 4;
        availablePreferencesLabel.setLayoutData((Object)availablePreferencesLabelGridData);
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        PreferenceFilteredTree availablePreferencesTree = new PreferenceFilteredTree(availablePreferencesComposite, 2050, filter);
        GridData availablePreferencesTreeGridData = new GridData();
        availablePreferencesTreeGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        availablePreferencesTreeGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        availablePreferencesTreeGridData.verticalAlignment = 4;
        availablePreferencesTreeGridData.horizontalAlignment = 4;
        availablePreferencesTreeGridData.grabExcessHorizontalSpace = true;
        availablePreferencesTreeGridData.grabExcessVerticalSpace = true;
        availablePreferencesTree.setLayoutData(availablePreferencesTreeGridData);
        Control filterControl = availablePreferencesTree.getChildren()[0];
        filterControl.setParent((Composite)filterGroupComposite);
        filterControl.setLayoutData((Object)new GridData(768));
        final TreeViewer availablePreferencesTreeViewer = availablePreferencesTree.getViewer();
        availablePreferencesTreeViewer.setContentProvider((IContentProvider)this.availablePreferencesContentProvider);
        availablePreferencesTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        if (!this.fromEclipsePreferenceFile) {
            input.getChildren().addAll(this.getAvailablePreferences());
        }
        availablePreferencesTreeViewer.setInput((Object)input);
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        final Button addButton = new Button(controlButtons, 8);
        addButton.setText("Add");
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        final Button removeButton = new Button(controlButtons, 8);
        removeButton.setText("Remove");
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Composite selectedPreferencesComposite = new Composite(contents, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        selectedPreferencesComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        selectedPreferencesComposite.setLayout((Layout)layout2);
        Label selectedPreferencesLabel = new Label(selectedPreferencesComposite, 0);
        selectedPreferencesLabel.setText("Selected Preferences");
        GridData selectedPreferencesLabelGridData = new GridData();
        selectedPreferencesLabelGridData.horizontalSpan = 2;
        selectedPreferencesLabelGridData.horizontalAlignment = 4;
        selectedPreferencesLabelGridData.verticalAlignment = 4;
        selectedPreferencesLabel.setLayoutData((Object)selectedPreferencesLabelGridData);
        Tree selectedPreferencesTree = new Tree(selectedPreferencesComposite, 2050);
        GridData selectedPreferencesTreeGridData = new GridData();
        selectedPreferencesTreeGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        selectedPreferencesTreeGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        selectedPreferencesTreeGridData.verticalAlignment = 4;
        selectedPreferencesTreeGridData.horizontalAlignment = 4;
        selectedPreferencesTreeGridData.grabExcessHorizontalSpace = true;
        selectedPreferencesTreeGridData.grabExcessVerticalSpace = true;
        selectedPreferencesTree.setLayoutData((Object)selectedPreferencesTreeGridData);
        final TreeViewer selectedPreferencesTreeViewer = new TreeViewer(selectedPreferencesTree);
        selectedPreferencesTreeViewer.setContentProvider((IContentProvider)this.selectedPreferencesContentProvider);
        selectedPreferencesTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        selectedPreferencesTreeViewer.setInput((Object)input);
        availablePreferencesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (addButton.isEnabled()) {
                    addButton.notifyListeners(13, null);
                }
            }
        });
        selectedPreferencesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (removeButton.isEnabled()) {
                    removeButton.notifyListeners(13, null);
                }
            }
        });
        addButton.addSelectionListener((SelectionListener)new FilteringSelectionAdapter(selectedPreferencesTreeViewer, availablePreferencesTreeViewer, input, true));
        removeButton.addSelectionListener((SelectionListener)new FilteringSelectionAdapter(selectedPreferencesTreeViewer, availablePreferencesTreeViewer, input, false));
        if (preferenceFileText != null) {
            preferenceFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PreferenceCaptureDialog.this.included.clear();
                    EList children = input.getChildren();
                    children.clear();
                    try {
                        HashMap<URI, Pair> preferences = new HashMap<URI, Pair>();
                        Map loadProperties = PropertiesUtil.loadProperties((File)new File(((Text)e.widget).getText()));
                        for (Map.Entry entry : loadProperties.entrySet()) {
                            String key = (String)entry.getKey();
                            if (!key.startsWith("/")) continue;
                            preferences.put(PreferencesFactory.eINSTANCE.createURI(key), new Pair(null, (Object)((String)entry.getValue())));
                        }
                        List availablePreferences = RecorderTransaction.record(preferences);
                        children.addAll((Collection)availablePreferences);
                    }
                    catch (IORuntimeException ex) {
                        children.add((Object)new ItemProvider(ex.getMessage(), UIPlugin.INSTANCE.getImage("error")));
                    }
                    availablePreferencesTreeViewer.refresh();
                    selectedPreferencesTreeViewer.refresh();
                }
            });
        }
        return contents;
    }

    public boolean close() {
        this.availablePreferencesContentProvider.dispose();
        this.selectedPreferencesContentProvider.dispose();
        return super.close();
    }

    public Map<URI, Pair<String, String>> getResult() {
        HashMap<URI, Pair<String, String>> result = new HashMap<URI, Pair<String, String>>();
        for (Object object : this.included) {
            PreferenceTask preferenceTask = (PreferenceTask)object;
            result.put(PreferencesFactory.eINSTANCE.createURI(preferenceTask.getKey()), (Pair<String, String>)new Pair(null, (Object)preferenceTask.getValue()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FilteringAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        private boolean include;

        private FilteringAdapterFactoryContentProvider(AdapterFactory adapterFactory, boolean include) {
            super(adapterFactory);
            this.include = include;
        }

        public TreeIterator<Object> getAllContents(Object object, boolean includeRoot) {
            return new AbstractTreeIterator<Object>(object, includeRoot){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends Object> getChildren(Object object) {
                    return Arrays.asList(object instanceof ItemProvider ? FilteringAdapterFactoryContentProvider.this.getElements(object) : FilteringAdapterFactoryContentProvider.this.getChildren(object)).iterator();
                }
            };
        }

        public Object[] getElements(Object object) {
            EList elements = ((ItemProvider)object).getChildren();
            ArrayList result = new ArrayList();
            block0: for (Object element : elements) {
                if (this.include) {
                    Object[] objectArray = this.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (PreferenceCaptureDialog.this.included.contains(child)) {
                            result.add(element);
                            continue block0;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (element instanceof ItemProvider) {
                    result.add(element);
                    continue;
                }
                if (PreferenceCaptureDialog.this.included.containsAll(Arrays.asList(this.getChildren(element)))) continue;
                result.add(element);
            }
            return result.toArray();
        }

        public Object[] getChildren(Object object) {
            Object[] children = super.getChildren(object);
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (PreferenceCaptureDialog.this.included.contains(child) == this.include) {
                    result.add(child);
                }
                ++n2;
            }
            return result.toArray();
        }
    }

    private class FilteringSelectionAdapter
    extends SelectionAdapter {
        private final TreeViewer selectedPreferencesTreeViewer;
        private final TreeViewer availablePreferencesTreeViewer;
        private final ItemProvider input;
        private boolean add;

        private FilteringSelectionAdapter(TreeViewer selectedPreferencesTreeViewer, TreeViewer availablePreferencesTreeViewer, ItemProvider input, boolean add) {
            this.selectedPreferencesTreeViewer = selectedPreferencesTreeViewer;
            this.availablePreferencesTreeViewer = availablePreferencesTreeViewer;
            this.input = input;
            this.add = add;
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection selection = (IStructuredSelection)(this.add ? this.availablePreferencesTreeViewer : this.selectedPreferencesTreeViewer).getSelection();
            ArrayList<Object> newSelection = new ArrayList<Object>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                Object[] children = (this.add ? PreferenceCaptureDialog.this.availablePreferencesContentProvider : PreferenceCaptureDialog.this.selectedPreferencesContentProvider).getChildren(object = objectArray[n2]);
                if (children.length != 0) {
                    List<Object> choices = Arrays.asList(children);
                    newSelection.addAll(choices);
                } else {
                    newSelection.add(object);
                }
                ++n2;
            }
            HashSet nonCandidates = new HashSet(newSelection);
            Object candidate = null;
            Object bestCandidate = null;
            TreeIterator<Object> it = (this.add ? PreferenceCaptureDialog.this.availablePreferencesContentProvider : PreferenceCaptureDialog.this.selectedPreferencesContentProvider).getAllContents(this.input, false);
            while (it.hasNext()) {
                candidate = it.next();
                if (nonCandidates.remove(candidate)) {
                    if (bestCandidate instanceof PreferenceTask) continue;
                    bestCandidate = null;
                    continue;
                }
                if (!(candidate instanceof CompoundTask)) {
                    bestCandidate = candidate;
                }
                if (nonCandidates.isEmpty()) break;
            }
            if (this.add) {
                PreferenceCaptureDialog.this.included.addAll(newSelection);
            } else {
                PreferenceCaptureDialog.this.included.removeAll(newSelection);
            }
            for (Object object : this.input.getChildren()) {
                CompoundTask compoundTask;
                EList setupTasks;
                if (!(object instanceof CompoundTask) || !newSelection.containsAll((Collection<?>)(setupTasks = (compoundTask = (CompoundTask)object).getSetupTasks()))) continue;
                newSelection.removeAll((Collection<?>)setupTasks);
                newSelection.add(compoundTask);
            }
            this.selectedPreferencesTreeViewer.refresh();
            this.availablePreferencesTreeViewer.refresh();
            (this.add ? this.selectedPreferencesTreeViewer : this.availablePreferencesTreeViewer).setSelection((ISelection)new StructuredSelection(newSelection));
            if (bestCandidate == null && candidate != null) {
                bestCandidate = candidate;
            }
            if (bestCandidate != null) {
                (this.add ? this.availablePreferencesTreeViewer : this.selectedPreferencesTreeViewer).setSelection((ISelection)new StructuredSelection(bestCandidate));
            }
        }
    }

    private static final class PreferenceFilteredTree
    extends FilteredTree {
        private static final IScopeContext DUMMY_CONFIGURATION_SCOPE = new DummyScope("configuration");
        private static final IScopeContext DUMMY_DEFAULT_SCOPE = new DummyScope("default");
        private static final IScopeContext DUMMY_INSTANCE_SCOPE = new DummyScope("instance");
        private static final IEclipsePreferences DUMMY_PREFERENCES = new DummyPreferences();
        private static final IScopeContext DUMMY_PROJECT_SCOPE = new DummyScope("project");
        private ToolItem defaultsToolItem;

        public PreferenceFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true);
        }

        protected Composite createFilterControls(Composite parent) {
            ((GridLayout)parent.getLayout()).numColumns = 3;
            Composite filters = super.createFilterControls(parent);
            ToolBar toolBar = new ToolBar(parent, 0x800100);
            this.defaultsToolItem = new ToolItem(toolBar, 32);
            this.defaultsToolItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("filter_advanced_properties"));
            this.defaultsToolItem.setToolTipText("Hide preferences set to their default value");
            this.defaultsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceFilteredTree.this.treeViewer.refresh();
                }
            });
            return filters;
        }

        protected Control createTreeControl(Composite parent, int style) {
            Control treeControl = super.createTreeControl(parent, style);
            this.treeViewer.addFilter(new ViewerFilter(){
                private final IPreferencesService preferencesService = Platform.getPreferencesService();
                private final IScopeContext[] defaultContexts = new IScopeContext[]{PreferenceFilteredTree.access$2(), PreferenceFilteredTree.access$3(), PreferenceFilteredTree.access$4(), DefaultScope.INSTANCE};
                private final IScopeContext[] preferenceContexts = new IScopeContext[]{PreferenceFilteredTree.access$2(), PreferenceFilteredTree.access$3(), PreferenceFilteredTree.access$4(), PreferenceFilteredTree.access$5()};
                private final Map<PreferenceTask, Boolean> selected = new HashMap<PreferenceTask, Boolean>();

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!PreferenceFilteredTree.this.defaultsToolItem.getSelection()) {
                        return true;
                    }
                    if (element instanceof CompoundTask) {
                        CompoundTask compoundTask = (CompoundTask)element;
                        EList setupTasks = compoundTask.getSetupTasks();
                        Object[] objectArray = PreferenceFilteredTree.this.getPatternFilter().filter(viewer, (Object)compoundTask, setupTasks.toArray());
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            if (this.select(viewer, compoundTask, child)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                    if (element instanceof PreferenceTask) {
                        Boolean result = this.selected.get(element);
                        if (result != null) {
                            return result;
                        }
                        PreferenceTask preferenceTask = (PreferenceTask)element;
                        String preferencePath = preferenceTask.getKey();
                        int index = preferencePath.indexOf(47, 1);
                        String scope = preferencePath.substring(1, index);
                        String keyWithoutScope = preferencePath.substring(index + 1);
                        index = keyWithoutScope.indexOf(47, 0);
                        String qualifier = keyWithoutScope.substring(0, index);
                        String key = keyWithoutScope.substring(index + 1);
                        IScopeContext instanceScope = DUMMY_INSTANCE_SCOPE;
                        IScopeContext configurationScope = DUMMY_CONFIGURATION_SCOPE;
                        if ("instance".equals(scope)) {
                            instanceScope = InstanceScope.INSTANCE;
                        } else if ("configuration".equals(scope)) {
                            configurationScope = ConfigurationScope.INSTANCE;
                        }
                        this.preferenceContexts[1] = instanceScope;
                        this.preferenceContexts[2] = configurationScope;
                        String defaultValue = this.preferencesService.getString(qualifier, key, null, this.defaultContexts);
                        String preferenceValue = this.preferencesService.getString(qualifier, key, null, this.preferenceContexts);
                        boolean isSelected = preferenceValue != null && !preferenceValue.equals(defaultValue);
                        this.selected.put(preferenceTask, isSelected);
                        return isSelected;
                    }
                    return true;
                }
            });
            return treeControl;
        }

        static /* synthetic */ IScopeContext access$2() {
            return DUMMY_PROJECT_SCOPE;
        }

        static /* synthetic */ IScopeContext access$5() {
            return DUMMY_DEFAULT_SCOPE;
        }

        private static final class DummyPreferences
        implements IEclipsePreferences {
            private DummyPreferences() {
            }

            public String absolutePath() {
                return null;
            }

            public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
            }

            public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
            }

            public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
            }

            public String[] childrenNames() throws BackingStoreException {
                return null;
            }

            public void clear() throws BackingStoreException {
            }

            public void flush() throws BackingStoreException {
            }

            public String get(String key, String def) {
                return def;
            }

            public boolean getBoolean(String key, boolean def) {
                return def;
            }

            public byte[] getByteArray(String key, byte[] def) {
                return def;
            }

            public double getDouble(String key, double def) {
                return def;
            }

            public float getFloat(String key, float def) {
                return def;
            }

            public int getInt(String key, int def) {
                return def;
            }

            public long getLong(String key, long def) {
                return def;
            }

            public String[] keys() throws BackingStoreException {
                return null;
            }

            public String name() {
                return null;
            }

            public Preferences node(String path) {
                return this;
            }

            public boolean nodeExists(String pathName) throws BackingStoreException {
                return false;
            }

            public Preferences parent() {
                return null;
            }

            public void put(String key, String value) {
            }

            public void putBoolean(String key, boolean value) {
            }

            public void putByteArray(String key, byte[] value) {
            }

            public void putDouble(String key, double value) {
            }

            public void putFloat(String key, float value) {
            }

            public void putInt(String key, int value) {
            }

            public void putLong(String key, long value) {
            }

            public void remove(String key) {
            }

            public void removeNode() throws BackingStoreException {
            }

            public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
            }

            public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
            }

            public void sync() throws BackingStoreException {
            }
        }

        private static final class DummyScope
        implements IScopeContext {
            private final String name;

            public DummyScope(String name) {
                this.name = name;
            }

            public IPath getLocation() {
                return null;
            }

            public String getName() {
                return this.name;
            }

            public IEclipsePreferences getNode(String qualifier) {
                return DUMMY_PREFERENCES;
            }
        }
    }
}

