/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPForeignObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreTableForeign
extends PostgreTable
implements DBPForeignObject,
DBPImageProvider {
    private long foreignServerId;
    private String[] foreignOptions;

    public PostgreTableForeign(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreTableForeign(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Property(viewable=false, order=200)
    public PostgreForeignServer getForeignServer(DBRProgressMonitor monitor) throws DBException {
        this.readForeignInfo(monitor);
        return (PostgreForeignServer)PostgreUtils.getObjectById(monitor, this.getDatabase().foreignServerCache, this.getDatabase(), this.foreignServerId);
    }

    @Property(viewable=false, order=201)
    public String[] getForeignOptions(DBRProgressMonitor monitor) throws DBException {
        this.readForeignInfo(monitor);
        return this.foreignOptions;
    }

    private void readForeignInfo(DBRProgressMonitor monitor) throws DBException {
        if (this.foreignServerId > 0L) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read foreign table info");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement stat = session.prepareStatement("SELECT * FROM pg_catalog.pg_foreign_table WHERE ftrelid=?");){
                    stat.setLong(1, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet result = stat.executeQuery();){
                        if (result.next()) {
                            this.foreignServerId = JDBCUtils.safeGetLong((ResultSet)result, (String)"ftserver");
                            this.foreignOptions = (String[])JDBCUtils.safeGetArray((ResultSet)result, (String)"ftoptions");
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
    }

    @Nullable
    public DBPImage getObjectImage() {
        return DBIcon.TREE_TABLE_LINK;
    }

    public boolean isForeignObject() {
        return true;
    }
}

