/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class PrefUtils {
    private static final Log log = Log.getLog(PrefUtils.class);

    public static void savePreferenceStore(DBPPreferenceStore store) {
        try {
            store.save();
        }
        catch (IOException e) {
            log.warn(e);
        }
    }

    public static void setDefaultPreferenceValue(DBPPreferenceStore store, String name, Object value) {
        if (CommonUtils.isEmpty((String)store.getDefaultString(name))) {
            store.setDefault(name, value.toString());
        }
    }

    public static Object getPreferenceValue(DBPPreferenceStore store, String propName, Class<?> valueType) {
        try {
            if (valueType == null || CharSequence.class.isAssignableFrom(valueType)) {
                String str = store.getString(propName);
                return CommonUtils.isEmpty((String)str) ? null : str;
            }
            if (valueType == Boolean.class || valueType == Boolean.TYPE) {
                return store.getBoolean(propName);
            }
            if (valueType == Long.class || valueType == Long.TYPE) {
                return store.getLong(propName);
            }
            if (valueType == Integer.class || valueType == Integer.TYPE || valueType == Short.class || valueType == Short.TYPE || valueType == Byte.class || valueType == Byte.TYPE) {
                return store.getInt(propName);
            }
            if (valueType == Double.class || valueType == Double.TYPE) {
                return store.getDouble(propName);
            }
            if (valueType == Float.class || valueType == Float.TYPE) {
                return Float.valueOf(store.getFloat(propName));
            }
            if (valueType == BigInteger.class) {
                String str = store.getString(propName);
                return str == null ? null : new BigInteger(str);
            }
            if (valueType == BigDecimal.class) {
                String str = store.getString(propName);
                return str == null ? null : new BigDecimal(str);
            }
        }
        catch (RuntimeException e) {
            log.error(e);
        }
        String string = store.getString(propName);
        return CommonUtils.isEmpty((String)string) ? null : string;
    }

    public static void setPreferenceValue(DBPPreferenceStore store, String propName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setValue(propName, value.toString());
        } else if (value instanceof Boolean) {
            store.setValue(propName, (Boolean)value);
        } else if (value instanceof Long) {
            store.setValue(propName, (Long)value);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setValue(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            store.setValue(propName, (Double)value);
        } else if (value instanceof Float) {
            store.setValue(propName, ((Float)value).floatValue());
        } else {
            store.setValue(propName, value.toString());
        }
    }

    public static void setPreferenceDefaultValue(DBPPreferenceStore store, String propName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setDefault(propName, value.toString());
        } else if (value instanceof Boolean) {
            store.setDefault(propName, (Boolean)value);
        } else if (value instanceof Long) {
            store.setDefault(propName, (Long)value);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setDefault(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            store.setDefault(propName, (Double)value);
        } else if (value instanceof Float) {
            store.setDefault(propName, ((Float)value).floatValue());
        } else {
            store.setDefault(propName, value.toString());
        }
    }
}

