/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PropertySourceCustom
implements DBPPropertySource {
    private List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<Object, Object> originalValues = new TreeMap<Object, Object>();
    private Map<Object, Object> propValues = new TreeMap<Object, Object>();
    private Map<Object, Object> defaultValues = new TreeMap<Object, Object>();

    public PropertySourceCustom() {
    }

    public PropertySourceCustom(Collection<? extends DBPPropertyDescriptor> properties, Map<?, ?> values) {
        this.addProperties(properties);
        this.setValues(values);
    }

    public void setValues(Map<?, ?> values) {
        this.originalValues = new HashMap<Object, Object>();
        if (values != null) {
            block0: for (Map.Entry<?, ?> value : values.entrySet()) {
                Object propValue = value.getValue();
                for (DBPPropertyDescriptor prop : this.props) {
                    if (!prop.getId().equals(value.getKey())) continue;
                    if (propValue instanceof String) {
                        propValue = GeneralUtils.convertString((String)value.getValue(), prop.getDataType());
                    }
                    this.originalValues.put(value.getKey(), propValue);
                    continue block0;
                }
            }
        }
    }

    public void setDefaultValues(Map<Object, Object> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void addDefaultValues(Map<Object, Object> defaultValues) {
        this.defaultValues.putAll(defaultValues);
    }

    public Map<Object, Object> getProperties() {
        HashMap<Object, Object> allValues = new HashMap<Object, Object>(this.originalValues);
        allValues.putAll(this.propValues);
        return allValues;
    }

    public Map<Object, Object> getPropertiesWithDefaults() {
        HashMap<Object, Object> allValues = new HashMap<Object, Object>(this.defaultValues);
        allValues.putAll(this.originalValues);
        allValues.putAll(this.propValues);
        return allValues;
    }

    public void addProperties(Collection<? extends DBPPropertyDescriptor> properties) {
        this.props.addAll(properties);
        for (DBPPropertyDescriptor dBPPropertyDescriptor : properties) {
            Object defaultValue = dBPPropertyDescriptor.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaultValues.put(dBPPropertyDescriptor.getId(), defaultValue);
        }
    }

    @Override
    public Object getEditableValue() {
        return this;
    }

    @Override
    public DBPPropertyDescriptor[] getPropertyDescriptors2() {
        return this.props.toArray(new DBPPropertyDescriptor[this.props.size()]);
    }

    @Override
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        if (id == null) {
            return null;
        }
        Object value = this.propValues.get(id);
        if (value == null) {
            value = this.originalValues.get(id);
        }
        return value != null ? value : this.defaultValues.get(id);
    }

    @Override
    public boolean isPropertyResettable(Object id) {
        return true;
    }

    @Override
    public boolean isPropertySet(Object id) {
        Object value = this.getPropertyValue(null, id);
        if (value == null) {
            return false;
        }
        Object defaultValue = this.defaultValues.get(id);
        return !CommonUtils.equalObjects((Object)value, (Object)defaultValue);
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        this.propValues.remove(id);
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object id, Object value) {
        if (!this.originalValues.containsKey(id)) {
            if (this.propValues.containsKey(id)) {
                this.originalValues.put(id, this.propValues.get(id));
            } else if (this.defaultValues.containsKey(id)) {
                this.originalValues.put(id, this.defaultValues.get(id));
            } else {
                this.originalValues.put(id, null);
            }
        }
        if (value == null || value.equals(this.originalValues.get(id))) {
            this.propValues.remove(id);
        } else {
            this.propValues.put(id, value);
        }
    }

    @Override
    public boolean isDirty(Object id) {
        return !this.propValues.isEmpty();
    }

    @Override
    public void resetPropertyValueToDefault(Object id) {
        this.propValues.remove(id);
        this.originalValues.remove(id);
    }
}

