"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const fs_1 = require("fs");
const electron_1 = require("electron");
const electron_util_1 = require("electron-util");
const config_1 = require("./config");
const util_1 = require("./util");
const emoji_1 = require("./emoji");
const menu_bar_mode_1 = require("./menu-bar-mode");
async function updateMenu() {
    const newConversationItem = {
        label: 'New Conversation',
        accelerator: 'CommandOrControl+N',
        click() {
            util_1.sendAction('new-conversation');
        }
    };
    const switchItems = [
        {
            label: 'Switch to Work Chat…',
            accelerator: 'CommandOrControl+Shift+2',
            visible: !config_1.default.get('useWorkChat'),
            click() {
                config_1.default.set('useWorkChat', true);
                electron_1.app.relaunch();
                electron_1.app.quit();
            }
        },
        {
            label: 'Switch to Messenger…',
            accelerator: 'CommandOrControl+Shift+1',
            visible: config_1.default.get('useWorkChat'),
            click() {
                config_1.default.set('useWorkChat', false);
                electron_1.app.relaunch();
                electron_1.app.quit();
            }
        },
        {
            label: 'Log Out',
            click() {
                util_1.sendAction('log-out');
            }
        }
    ];
    const vibrancySubmenu = [
        {
            label: 'No Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'none',
            async click() {
                config_1.default.set('vibrancy', 'none');
                util_1.sendAction('update-vibrancy');
                await updateMenu();
            }
        },
        {
            label: 'Sidebar-only Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'sidebar',
            async click() {
                config_1.default.set('vibrancy', 'sidebar');
                util_1.sendAction('update-vibrancy');
                await updateMenu();
            }
        },
        {
            label: 'Full-window Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'full',
            async click() {
                config_1.default.set('vibrancy', 'full');
                util_1.sendAction('update-vibrancy');
                await updateMenu();
            }
        }
    ];
    const privacySubmenu = [
        {
            label: 'Block Seen Indicator',
            type: 'checkbox',
            checked: config_1.default.get('block.chatSeen'),
            click(menuItem) {
                config_1.default.set('block.chatSeen', menuItem.checked);
            }
        },
        {
            label: 'Block Typing Indicator',
            type: 'checkbox',
            checked: config_1.default.get('block.typingIndicator'),
            click(menuItem) {
                config_1.default.set('block.typingIndicator', menuItem.checked);
            }
        },
        {
            label: 'Block Delivery Receipts',
            type: 'checkbox',
            checked: config_1.default.get('block.deliveryReceipt'),
            click(menuItem) {
                config_1.default.set('block.deliveryReceipt', menuItem.checked);
            }
        }
    ];
    const advancedSubmenu = [
        {
            label: 'Custom Styles',
            click() {
                const filePath = path.join(electron_1.app.getPath('userData'), 'custom.css');
                const defaultCustomStyle = `/*
This is the custom styles file where you can add anything you want.
The styles here will be injected into Caprine and will override default styles.
If you want to disable styles but keep the config, just comment the lines that you don't want to be used.

Here are some dark mode color variables to get you started.
Edit them to change color scheme of Caprine.
Press Command/Ctrl+R in Caprine to see your changes.
*/

:root {
	--base: #000;
	--base-ninety: rgba(255, 255, 255, 0.9);
	--base-seventy-five: rgba(255, 255, 255, 0.75);
	--base-seventy: rgba(255, 255, 255, 0.7);
	--base-fifty: rgba(255, 255, 255, 0.5);
	--base-fourty: rgba(255, 255, 255, 0.4);
	--base-thirty: rgba(255, 255, 255, 0.3);
	--base-twenty: rgba(255, 255, 255, 0.2);
	--base-five: rgba(255, 255, 255, 0.05);
	--base-ten: rgba(255, 255, 255, 0.1);
	--base-nine: rgba(255, 255, 255, 0.09);
	--container-color: #323232;
	--container-dark-color: #1e1e1e;
	--list-header-color: #222;
	--blue: #0084ff;
	--selected-conversation-background: linear-gradient(hsla(209, 110%, 45%, 0.9), hsla(209, 110%, 42%, 0.9));
}
`;
                if (!fs_1.existsSync(filePath)) {
                    fs_1.writeFileSync(filePath, defaultCustomStyle, 'utf8');
                }
                electron_1.shell.openItem(filePath);
            }
        }
    ];
    const preferencesSubmenu = [
        {
            label: 'Privacy',
            submenu: privacySubmenu
        },
        {
            label: 'Emoji Style',
            submenu: await emoji_1.generateSubmenu(updateMenu)
        },
        {
            label: 'Bounce Dock on Message',
            type: 'checkbox',
            visible: electron_util_1.is.macos,
            checked: config_1.default.get('bounceDockOnMessage'),
            click() {
                config_1.default.set('bounceDockOnMessage', !config_1.default.get('bounceDockOnMessage'));
            }
        },
        {
            label: 'Autoplay Videos',
            id: 'video-autoplay',
            type: 'checkbox',
            checked: config_1.default.get('autoplayVideos'),
            click() {
                config_1.default.set('autoplayVideos', !config_1.default.get('autoplayVideos'));
                util_1.sendAction('toggle-video-autoplay');
            }
        },
        {
            label: 'Show Message Preview in Notifications',
            type: 'checkbox',
            checked: config_1.default.get('notificationMessagePreview'),
            click(menuItem) {
                config_1.default.set('notificationMessagePreview', menuItem.checked);
            }
        },
        {
            label: 'Mute Notifications',
            id: 'mute-notifications',
            type: 'checkbox',
            checked: config_1.default.get('notificationsMuted'),
            click() {
                util_1.sendAction('toggle-mute-notifications');
            }
        },
        {
            label: 'Show Unread Badge',
            type: 'checkbox',
            checked: config_1.default.get('showUnreadBadge'),
            click() {
                config_1.default.set('showUnreadBadge', !config_1.default.get('showUnreadBadge'));
            }
        },
        {
            label: 'Hardware Acceleration',
            type: 'checkbox',
            checked: config_1.default.get('hardwareAcceleration'),
            click() {
                config_1.default.set('hardwareAcceleration', !config_1.default.get('hardwareAcceleration'));
                util_1.showRestartDialog('Caprine needs to be restarted to change hardware acceleration.');
            }
        },
        {
            label: 'Show Menu Bar Icon',
            id: 'menuBarMode',
            type: 'checkbox',
            visible: electron_util_1.is.macos,
            checked: config_1.default.get('menuBarMode'),
            click() {
                config_1.default.set('menuBarMode', !config_1.default.get('menuBarMode'));
                const [win] = electron_1.BrowserWindow.getAllWindows();
                menu_bar_mode_1.toggleMenuBarMode(win);
            }
        },
        {
            label: 'Always on Top',
            type: 'checkbox',
            accelerator: 'CommandOrControl+Shift+T',
            checked: config_1.default.get('alwaysOnTop'),
            click(menuItem, focusedWindow) {
                config_1.default.set('alwaysOnTop', menuItem.checked);
                focusedWindow.setAlwaysOnTop(menuItem.checked);
            }
        },
        {
            label: 'Launch at Login',
            visible: electron_util_1.is.macos || electron_util_1.is.windows,
            type: 'checkbox',
            checked: electron_1.app.getLoginItemSettings().openAtLogin,
            click(menuItem) {
                electron_1.app.setLoginItemSettings({
                    openAtLogin: menuItem.checked,
                    openAsHidden: menuItem.checked
                });
            }
        },
        {
            label: 'Auto Hide Menu Bar',
            type: 'checkbox',
            visible: !electron_util_1.is.macos,
            checked: config_1.default.get('autoHideMenuBar'),
            click(menuItem, focusedWindow) {
                config_1.default.set('autoHideMenuBar', menuItem.checked);
                focusedWindow.setAutoHideMenuBar(menuItem.checked);
                focusedWindow.setMenuBarVisibility(!menuItem.checked);
            }
        },
        {
            label: 'Flash Window on Message',
            type: 'checkbox',
            visible: !electron_util_1.is.macos,
            checked: config_1.default.get('flashWindowOnMessage'),
            click(menuItem) {
                config_1.default.set('flashWindowOnMessage', menuItem.checked);
            }
        },
        {
            label: 'Show Tray Icon',
            type: 'checkbox',
            enabled: electron_util_1.is.linux || electron_util_1.is.windows,
            checked: config_1.default.get('showTrayIcon'),
            click() {
                config_1.default.set('showTrayIcon', !config_1.default.get('showTrayIcon'));
                util_1.sendAction('toggle-tray-icon');
            }
        },
        {
            label: 'Launch Minimized',
            type: 'checkbox',
            visible: !electron_util_1.is.macos,
            checked: config_1.default.get('launchMinimized'),
            click() {
                config_1.default.set('launchMinimized', !config_1.default.get('launchMinimized'));
                util_1.sendAction('toggle-tray-icon');
            }
        },
        {
            label: 'Quit on Window Close',
            type: 'checkbox',
            checked: config_1.default.get('quitOnWindowClose'),
            click() {
                config_1.default.set('quitOnWindowClose', !config_1.default.get('quitOnWindowClose'));
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Advanced',
            submenu: advancedSubmenu
        }
    ];
    const viewSubmenu = [
        {
            label: 'Reset Text Size',
            accelerator: 'CommandOrControl+0',
            click() {
                util_1.sendAction('zoom-reset');
            }
        },
        {
            label: 'Increase Text Size',
            accelerator: 'CommandOrControl+Plus',
            click() {
                util_1.sendAction('zoom-in');
            }
        },
        {
            label: 'Decrease Text Size',
            accelerator: 'CommandOrControl+-',
            click() {
                util_1.sendAction('zoom-out');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Follow System Appearance',
            type: 'checkbox',
            visible: electron_util_1.is.macos,
            checked: config_1.default.get('followSystemAppearance'),
            async click() {
                config_1.default.set('followSystemAppearance', !config_1.default.get('followSystemAppearance'));
                util_1.sendAction('set-dark-mode');
                await updateMenu();
            }
        },
        {
            label: 'Dark Mode',
            id: 'darkMode',
            type: 'checkbox',
            checked: config_1.default.get('darkMode'),
            enabled: !electron_util_1.is.macos || !config_1.default.get('followSystemAppearance'),
            accelerator: 'CommandOrControl+D',
            click() {
                config_1.default.set('darkMode', !config_1.default.get('darkMode'));
                util_1.sendAction('set-dark-mode');
            }
        },
        {
            label: 'Vibrancy',
            visible: electron_util_1.is.macos,
            submenu: vibrancySubmenu
        },
        {
            type: 'separator'
        },
        {
            label: 'Hide Names and Avatars',
            id: 'privateMode',
            type: 'checkbox',
            checked: config_1.default.get('privateMode'),
            accelerator: 'CommandOrControl+Shift+N',
            click() {
                config_1.default.set('privateMode', !config_1.default.get('privateMode'));
                util_1.sendAction('set-private-mode');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Show Sidebar',
            type: 'checkbox',
            checked: !config_1.default.get('sidebarHidden'),
            accelerator: 'CommandOrControl+Shift+S',
            click() {
                util_1.sendAction('toggle-sidebar');
            }
        },
        {
            label: 'Show Message Buttons',
            type: 'checkbox',
            checked: config_1.default.get('showMessageButtons'),
            click() {
                config_1.default.set('showMessageButtons', !config_1.default.get('showMessageButtons'));
                util_1.sendAction('toggle-message-buttons');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Show Active Contacts',
            click() {
                util_1.sendAction('show-active-contacts-view');
            }
        },
        {
            label: 'Show Message Requests',
            click() {
                util_1.sendAction('show-message-requests-view');
            }
        },
        {
            label: 'Show Archived Threads',
            click() {
                util_1.sendAction('show-archived-threads-view');
            }
        },
        {
            label: 'Toggle Unread Threads',
            click() {
                util_1.sendAction('toggle-unread-threads-view');
            }
        }
    ];
    const conversationSubmenu = [
        {
            label: 'Mute Conversation',
            accelerator: 'CommandOrControl+Shift+M',
            click() {
                util_1.sendAction('mute-conversation');
            }
        },
        {
            label: 'Archive Conversation',
            accelerator: 'CommandOrControl+Shift+A',
            click() {
                util_1.sendAction('archive-conversation');
            }
        },
        {
            label: 'Delete Conversation',
            accelerator: 'CommandOrControl+Shift+D',
            click() {
                util_1.sendAction('delete-conversation');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Select Next Conversation',
            accelerator: 'Control+Tab',
            click() {
                util_1.sendAction('next-conversation');
            }
        },
        {
            label: 'Select Previous Conversation',
            accelerator: 'Control+Shift+Tab',
            click() {
                util_1.sendAction('previous-conversation');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Find Conversation',
            accelerator: 'CommandOrControl+K',
            click() {
                util_1.sendAction('find');
            }
        },
        {
            label: 'Search in Conversation',
            accelerator: 'CommandOrControl+F',
            click() {
                util_1.sendAction('search');
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Insert GIF',
            accelerator: 'CommandOrControl+G',
            click() {
                util_1.sendAction('insert-gif');
            }
        },
        {
            label: 'Insert Sticker',
            accelerator: 'CommandOrControl+S',
            click() {
                util_1.sendAction('insert-sticker');
            }
        },
        {
            label: 'Insert Emoji',
            accelerator: 'CommandOrControl+E',
            click() {
                util_1.sendAction('insert-emoji');
            }
        },
        {
            label: 'Insert Text',
            accelerator: 'CommandOrControl+I',
            click() {
                util_1.sendAction('insert-text');
            }
        }
    ];
    const helpSubmenu = [
        electron_util_1.openUrlMenuItem({
            label: 'Website',
            url: 'https://sindresorhus.com/caprine'
        }),
        electron_util_1.openUrlMenuItem({
            label: 'Source Code',
            url: 'https://github.com/sindresorhus/caprine'
        }),
        electron_util_1.openUrlMenuItem({
            label: 'Donate…',
            url: 'https://github.com/sindresorhus/caprine?sponsor=1'
        }),
        {
            label: 'Report an Issue…',
            click() {
                const body = `
<!-- Please succinctly describe your issue and steps to reproduce it. -->


---

${electron_util_1.debugInfo()}`;
                electron_util_1.openNewGitHubIssue({
                    user: 'sindresorhus',
                    repo: 'caprine',
                    body
                });
            }
        }
    ];
    if (!electron_util_1.is.macos) {
        helpSubmenu.push({
            type: 'separator'
        }, electron_util_1.aboutMenuItem({
            icon: path.join(__dirname, '..', 'static', 'Icon.png'),
            text: 'Created by Sindre Sorhus'
        }));
    }
    const debugSubmenu = [
        {
            label: 'Show Settings',
            click() {
                config_1.default.openInEditor();
            }
        },
        {
            label: 'Show App Data',
            click() {
                electron_1.shell.openItem(electron_1.app.getPath('userData'));
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Delete Settings',
            click() {
                config_1.default.clear();
                electron_1.app.relaunch();
                electron_1.app.quit();
            }
        },
        {
            label: 'Delete App Data',
            click() {
                electron_1.shell.moveItemToTrash(electron_1.app.getPath('userData'));
                electron_1.app.relaunch();
                electron_1.app.quit();
            }
        }
    ];
    const macosTemplate = [
        electron_util_1.appMenu([
            {
                label: 'Caprine Preferences',
                submenu: preferencesSubmenu
            },
            {
                label: 'Messenger Preferences…',
                accelerator: 'Command+,',
                click() {
                    util_1.sendAction('show-preferences');
                }
            },
            {
                type: 'separator'
            },
            ...switchItems
        ]),
        {
            // @ts-ignore Buggy Electron types
            role: 'fileMenu',
            submenu: [
                newConversationItem,
                {
                    type: 'separator'
                },
                {
                    role: 'close'
                }
            ]
        },
        {
            // @ts-ignore Buggy Electron types
            role: 'editMenu'
        },
        {
            // @ts-ignore Buggy Electron types
            role: 'viewMenu',
            submenu: viewSubmenu
        },
        {
            label: 'Conversation',
            submenu: conversationSubmenu
        },
        {
            // @ts-ignore Buggy Electron types
            role: 'windowMenu'
        },
        {
            role: 'help',
            submenu: helpSubmenu
        }
    ];
    const linuxWindowsTemplate = [
        {
            // @ts-ignore Buggy Electron types
            role: 'fileMenu',
            submenu: [
                newConversationItem,
                {
                    type: 'separator'
                },
                {
                    label: 'Caprine Settings',
                    submenu: preferencesSubmenu
                },
                {
                    label: 'Messenger Settings',
                    accelerator: 'Control+,',
                    click() {
                        util_1.sendAction('show-preferences');
                    }
                },
                {
                    type: 'separator'
                },
                ...switchItems,
                {
                    type: 'separator'
                },
                {
                    role: 'quit'
                }
            ]
        },
        {
            // @ts-ignore Buggy Electron types
            role: 'editMenu'
        },
        {
            // @ts-ignore Buggy Electron types
            role: 'viewMenu',
            submenu: viewSubmenu
        },
        {
            label: 'Conversation',
            submenu: conversationSubmenu
        },
        {
            role: 'help',
            submenu: helpSubmenu
        }
    ];
    const template = electron_util_1.is.macos ? macosTemplate : linuxWindowsTemplate;
    if (electron_util_1.is.development) {
        template.push({
            label: 'Debug',
            submenu: debugSubmenu
        });
    }
    const menu = electron_1.Menu.buildFromTemplate(template);
    electron_1.Menu.setApplicationMenu(menu);
    return menu;
}
exports.default = updateMenu;
//# sourceMappingURL=menu.js.map