(function() {
  var CommentScopeRegex, Token, TokenizedLine, idCounter, isWhitespaceOnly;

  Token = require('./token');

  CommentScopeRegex = /(\b|\.)comment/;

  idCounter = 1;

  module.exports = TokenizedLine = (function() {
    function TokenizedLine(properties) {
      var tokens;
      this.id = idCounter++;
      if (properties == null) {
        return;
      }
      this.openScopes = properties.openScopes, this.text = properties.text, this.tags = properties.tags, this.ruleStack = properties.ruleStack, this.tokenIterator = properties.tokenIterator, this.grammar = properties.grammar, tokens = properties.tokens;
      this.cachedTokens = tokens;
    }

    TokenizedLine.prototype.getTokenIterator = function() {
      return this.tokenIterator.reset(this);
    };

    Object.defineProperty(TokenizedLine.prototype, 'tokens', {
      get: function() {
        var iterator, tokens;
        if (this.cachedTokens) {
          return this.cachedTokens;
        } else {
          iterator = this.getTokenIterator();
          tokens = [];
          while (iterator.next()) {
            tokens.push(new Token({
              value: iterator.getText(),
              scopes: iterator.getScopes().slice()
            }));
          }
          return tokens;
        }
      }
    });

    TokenizedLine.prototype.tokenAtBufferColumn = function(bufferColumn) {
      return this.tokens[this.tokenIndexAtBufferColumn(bufferColumn)];
    };

    TokenizedLine.prototype.tokenIndexAtBufferColumn = function(bufferColumn) {
      var column, i, index, len, ref, token;
      column = 0;
      ref = this.tokens;
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        token = ref[index];
        column += token.value.length;
        if (column > bufferColumn) {
          return index;
        }
      }
      return index - 1;
    };

    TokenizedLine.prototype.tokenStartColumnForBufferColumn = function(bufferColumn) {
      var delta, i, len, nextDelta, ref, token;
      delta = 0;
      ref = this.tokens;
      for (i = 0, len = ref.length; i < len; i++) {
        token = ref[i];
        nextDelta = delta + token.bufferDelta;
        if (nextDelta > bufferColumn) {
          break;
        }
        delta = nextDelta;
      }
      return delta;
    };

    TokenizedLine.prototype.isComment = function() {
      var i, j, len, len1, ref, ref1, startIndex, tag;
      if (this.isCommentLine != null) {
        return this.isCommentLine;
      }
      this.isCommentLine = false;
      ref = this.openScopes;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      startIndex = 0;
      ref1 = this.tags;
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        tag = ref1[j];
        if (tag > 0) {
          if (!isWhitespaceOnly(this.text.substr(startIndex, tag))) {
            break;
          }
          startIndex += tag;
        }
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      return this.isCommentLine;
    };

    TokenizedLine.prototype.isCommentOpenTag = function(tag) {
      var scope;
      if (tag < 0 && (tag & 1) === 1) {
        scope = this.grammar.scopeForId(tag);
        if (CommentScopeRegex.test(scope)) {
          return true;
        }
      }
      return false;
    };

    TokenizedLine.prototype.tokenAtIndex = function(index) {
      return this.tokens[index];
    };

    TokenizedLine.prototype.getTokenCount = function() {
      var count, i, len, ref, tag;
      count = 0;
      ref = this.tags;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (tag >= 0) {
          count++;
        }
      }
      return count;
    };

    return TokenizedLine;

  })();

  isWhitespaceOnly = function(text) {
    var char, i, len;
    for (i = 0, len = text.length; i < len; i++) {
      char = text[i];
      if (char !== '\t' && char !== ' ') {
        return false;
      }
    }
    return true;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
