(function() {
  var Disposable, StatusBarView, Tile;

  Disposable = require('atom').Disposable;

  Tile = require('./tile');

  module.exports = StatusBarView = (function() {
    function StatusBarView() {
      var flexboxHackElement;
      this.element = document.createElement('status-bar');
      this.element.classList.add('status-bar');
      flexboxHackElement = document.createElement('div');
      flexboxHackElement.classList.add('flexbox-repaint-hack');
      this.element.appendChild(flexboxHackElement);
      this.leftPanel = document.createElement('div');
      this.leftPanel.classList.add('status-bar-left');
      flexboxHackElement.appendChild(this.leftPanel);
      this.element.leftPanel = this.leftPanel;
      this.rightPanel = document.createElement('div');
      this.rightPanel.classList.add('status-bar-right');
      flexboxHackElement.appendChild(this.rightPanel);
      this.element.rightPanel = this.rightPanel;
      this.leftTiles = [];
      this.rightTiles = [];
      this.element.getLeftTiles = this.getLeftTiles.bind(this);
      this.element.getRightTiles = this.getRightTiles.bind(this);
      this.element.addLeftTile = this.addLeftTile.bind(this);
      this.element.addRightTile = this.addRightTile.bind(this);
      this.bufferSubscriptions = [];
      this.activeItemSubscription = atom.workspace.getCenter().onDidChangeActivePaneItem((function(_this) {
        return function() {
          _this.unsubscribeAllFromBuffer();
          _this.storeActiveBuffer();
          _this.subscribeAllToBuffer();
          return _this.element.dispatchEvent(new CustomEvent('active-buffer-changed', {
            bubbles: true
          }));
        };
      })(this));
      this.storeActiveBuffer();
    }

    StatusBarView.prototype.destroy = function() {
      this.activeItemSubscription.dispose();
      this.unsubscribeAllFromBuffer();
      return this.element.remove();
    };

    StatusBarView.prototype.addLeftTile = function(options) {
      var i, index, item, len, newElement, newItem, newPriority, newTile, nextElement, nextItem, priority, ref, ref1, ref2;
      newItem = options.item;
      newPriority = (ref = options != null ? options.priority : void 0) != null ? ref : this.leftTiles[this.leftTiles.length - 1].priority + 1;
      nextItem = null;
      ref1 = this.leftTiles;
      for (index = i = 0, len = ref1.length; i < len; index = ++i) {
        ref2 = ref1[index], priority = ref2.priority, item = ref2.item;
        if (priority > newPriority) {
          nextItem = item;
          break;
        }
      }
      newTile = new Tile(newItem, newPriority, this.leftTiles);
      this.leftTiles.splice(index, 0, newTile);
      newElement = atom.views.getView(newItem);
      nextElement = atom.views.getView(nextItem);
      this.leftPanel.insertBefore(newElement, nextElement);
      return newTile;
    };

    StatusBarView.prototype.addRightTile = function(options) {
      var i, index, item, len, newElement, newItem, newPriority, newTile, nextElement, nextItem, priority, ref, ref1, ref2;
      newItem = options.item;
      newPriority = (ref = options != null ? options.priority : void 0) != null ? ref : this.rightTiles[0].priority + 1;
      nextItem = null;
      ref1 = this.rightTiles;
      for (index = i = 0, len = ref1.length; i < len; index = ++i) {
        ref2 = ref1[index], priority = ref2.priority, item = ref2.item;
        if (priority < newPriority) {
          nextItem = item;
          break;
        }
      }
      newTile = new Tile(newItem, newPriority, this.rightTiles);
      this.rightTiles.splice(index, 0, newTile);
      newElement = atom.views.getView(newItem);
      nextElement = atom.views.getView(nextItem);
      this.rightPanel.insertBefore(newElement, nextElement);
      return newTile;
    };

    StatusBarView.prototype.getLeftTiles = function() {
      return this.leftTiles;
    };

    StatusBarView.prototype.getRightTiles = function() {
      return this.rightTiles;
    };

    StatusBarView.prototype.getActiveBuffer = function() {
      return this.buffer;
    };

    StatusBarView.prototype.getActiveItem = function() {
      return atom.workspace.getCenter().getActivePaneItem();
    };

    StatusBarView.prototype.storeActiveBuffer = function() {
      var ref;
      return this.buffer = (ref = this.getActiveItem()) != null ? typeof ref.getBuffer === "function" ? ref.getBuffer() : void 0 : void 0;
    };

    StatusBarView.prototype.subscribeToBuffer = function(event, callback) {
      this.bufferSubscriptions.push([event, callback]);
      if (this.buffer) {
        return this.buffer.on(event, callback);
      }
    };

    StatusBarView.prototype.subscribeAllToBuffer = function() {
      var callback, event, i, len, ref, ref1, results;
      if (!this.buffer) {
        return;
      }
      ref = this.bufferSubscriptions;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        ref1 = ref[i], event = ref1[0], callback = ref1[1];
        results.push(this.buffer.on(event, callback));
      }
      return results;
    };

    StatusBarView.prototype.unsubscribeAllFromBuffer = function() {
      var callback, event, i, len, ref, ref1, results;
      if (!this.buffer) {
        return;
      }
      ref = this.bufferSubscriptions;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        ref1 = ref[i], event = ref1[0], callback = ref1[1];
        results.push(this.buffer.off(event, callback));
      }
      return results;
    };

    return StatusBarView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
