Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var CorrectionsView = (function () {
  function CorrectionsView(editor, corrections, marker, updateTarget, updateCallback) {
    var _this = this;

    _classCallCheck(this, CorrectionsView);

    this.editor = editor;
    this.corrections = corrections;
    this.marker = marker;
    this.updateTarget = updateTarget;
    this.updateCallback = updateCallback;
    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No corrections',
      items: this.corrections,
      filterKeyForItem: function filterKeyForItem(item) {
        return item.label;
      },
      elementForItem: function elementForItem(item) {
        var element = document.createElement('li');
        if (item.isSuggestion) {
          // This is a word replacement suggestion.
          element.textContent = item.label;
        } else {
          // This is an operation such as add word.
          var em = document.createElement('em');
          em.textContent = item.label;
          element.appendChild(em);
        }
        return element;
      },
      didConfirmSelection: function didConfirmSelection(item) {
        _this.editor.transact(function () {
          if (item.isSuggestion) {
            // Update the buffer with the correction.
            _this.editor.setSelectedBufferRange(_this.marker.getBufferRange());
            _this.editor.insertText(item.suggestion);
          } else {
            // Build up the arguments object for this buffer and text.
            var projectPath = null;
            var relativePath = null;
            if (_this.editor && _this.editor.buffer && _this.editor.buffer.file && _this.editor.buffer.file.path) {
              var _atom$project$relativizePath = atom.project.relativizePath(_this.editor.buffer.file.path);

              var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 2);

              projectPath = _atom$project$relativizePath2[0];
              relativePath = _atom$project$relativizePath2[1];
            }

            var args = { id: _this.id, projectPath: projectPath, relativePath: relativePath };
            // Send the "add" request to the plugin.
            item.plugin.add(args, item);
            // Update the buffer to handle the corrections.
            _this.updateCallback.bind(_this.updateTarget)();
          }
        });
        _this.destroy();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.destroy();
      },
      didCancelSelection: function didCancelSelection() {
        _this.destroy();
      }
    });
    this.selectListView.element.classList.add('spell-check-corrections', 'corrections', 'popover-list');
  }

  _createClass(CorrectionsView, [{
    key: 'attach',
    value: function attach() {
      var _this2 = this;

      this.previouslyFocusedElement = document.activeElement;
      this.overlayDecoration = this.editor.decorateMarker(this.marker, { type: 'overlay', item: this.selectListView });
      process.nextTick(function () {
        atom.views.readDocument(function () {
          _this2.selectListView.focus();
        });
      });
    }
  }, {
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      if (!this.destroyed) {
        this.destroyed = true;
        this.overlayDecoration.destroy();
        yield this.selectListView.destroy();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
      }
    })
  }]);

  return CorrectionsView;
})();

exports['default'] = CorrectionsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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