"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _githubLoginView = _interopRequireDefault(require("./github-login-view"));

var _errorView = _interopRequireDefault(require("./error-view"));

var _offlineView = _interopRequireDefault(require("./offline-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorView extends _react["default"].Component {
  render() {
    const e = this.props.error;

    if (e.response) {
      switch (e.response.status) {
        case 401:
          return this.render401();

        case 200:
          // Do the default
          break;

        default:
          return this.renderUnknown(e.response, e.responseText);
      }
    }

    if (e.errors) {
      return this.renderGraphQLErrors(e.errors);
    }

    if (e.network) {
      return this.renderNetworkError();
    }

    return _react["default"].createElement(_errorView["default"], _extends({
      title: e.message,
      descriptions: [e.stack],
      preformatted: true
    }, this.errorViewProps()));
  }

  renderGraphQLErrors(errors) {
    return _react["default"].createElement(_errorView["default"], _extends({
      title: "Query errors reported",
      descriptions: errors.map(e => e.message)
    }, this.errorViewProps()));
  }

  renderNetworkError() {
    return _react["default"].createElement(_offlineView["default"], {
      retry: this.props.retry
    });
  }

  render401() {
    return _react["default"].createElement("div", {
      className: "github-GithubLoginView-Container"
    }, _react["default"].createElement(_githubLoginView["default"], {
      onLogin: this.props.login
    }, _react["default"].createElement("p", null, "The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.")));
  }

  renderUnknown(response, text) {
    return _react["default"].createElement(_errorView["default"], _extends({
      title: `Received an error response: ${response.status}`,
      descriptions: [text],
      preformatted: true
    }, this.errorViewProps()));
  }

  errorViewProps() {
    return {
      retry: this.props.retry,
      logout: this.props.logout
    };
  }

}

exports["default"] = QueryErrorView;

_defineProperty(QueryErrorView, "propTypes", {
  error: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    message: _propTypes["default"].string.isRequired,
    stack: _propTypes["default"].string.isRequired,
    response: _propTypes["default"].shape({
      status: _propTypes["default"].number.isRequired
    }),
    responseText: _propTypes["default"].string,
    errors: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      message: _propTypes["default"].string.isRequired
    }))
  }).isRequired,
  login: _propTypes["default"].func.isRequired,
  retry: _propTypes["default"].func,
  logout: _propTypes["default"].func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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