"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _url = require("url");

var _moment = _interopRequireDefault(require("moment"));

var _buildStatus = require("./build-status");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

class Issueish {
  constructor(data) {
    const author = data.author || _helpers.GHOST_USER;
    this.number = data.number;
    this.title = data.title;
    this.url = new _url.URL(data.url);
    this.authorLogin = author.login;
    this.authorAvatarURL = new _url.URL(author.avatarUrl);
    this.createdAt = (0, _moment["default"])(data.createdAt, _moment["default"].ISO_8601);
    this.headRefName = data.headRefName;
    this.headRepositoryID = data.repository.id;
    this.latestCommit = null;
    this.statusContexts = [];
    this.checkRuns = [];

    if (data.commits.nodes.length > 0) {
      this.latestCommit = data.commits.nodes[0].commit;
    }

    if (this.latestCommit && this.latestCommit.status) {
      this.statusContexts = this.latestCommit.status.contexts;
    }
  }

  getNumber() {
    return this.number;
  }

  getTitle() {
    return this.title;
  }

  getGitHubURL() {
    return this.url.toString();
  }

  getAuthorLogin() {
    return this.authorLogin;
  }

  getAuthorAvatarURL(size = 32) {
    const u = new _url.URL(this.authorAvatarURL.toString());
    u.searchParams.set('s', size);
    return u.toString();
  }

  getCreatedAt() {
    return this.createdAt;
  }

  getHeadRefName() {
    return this.headRefName;
  }

  getHeadRepositoryID() {
    return this.headRepositoryID;
  }

  getLatestCommit() {
    return this.latestCommit;
  }

  setCheckRuns(runsBySuite) {
    this.checkRuns = [];

    for (const [, runs] of runsBySuite) {
      for (const checkRun of runs) {
        this.checkRuns.push(checkRun);
      }
    }
  }

  getStatusCounts() {
    const buildStatuses = [];

    for (const context of this.statusContexts) {
      buildStatuses.push((0, _buildStatus.buildStatusFromStatusContext)(context));
    }

    for (const checkRun of this.checkRuns) {
      buildStatuses.push((0, _buildStatus.buildStatusFromCheckResult)(checkRun));
    }

    const counts = {
      pending: 0,
      failure: 0,
      success: 0,
      neutral: 0
    };

    for (const _ref of buildStatuses) {
      const {
        classSuffix
      } = _ref;
      counts[classSuffix]++;
    }

    return counts;
  }

}

exports["default"] = Issueish;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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