(function() {
  var CLASSES, clone, firstCharsEqual, fs, path, propertyPrefixPattern;

  fs = require('fs');

  path = require('path');

  CLASSES = require('../completions.json');

  propertyPrefixPattern = /(?:^|\[|\(|,|=|:|\s)\s*(atom\.(?:[a-zA-Z]+\.?){0,2})$/;

  module.exports = {
    selector: '.source.coffee, .source.js',
    filterSuggestions: true,
    getSuggestions: function(arg) {
      var bufferPosition, editor, line;
      bufferPosition = arg.bufferPosition, editor = arg.editor;
      if (!this.isEditingAnAtomPackageFile(editor)) {
        return;
      }
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return this.getCompletions(line);
    },
    load: function() {
      this.loadCompletions();
      atom.project.onDidChangePaths((function(_this) {
        return function() {
          return _this.scanProjectDirectories();
        };
      })(this));
      return this.scanProjectDirectories();
    },
    scanProjectDirectories: function() {
      this.packageDirectories = [];
      return atom.project.getDirectories().forEach((function(_this) {
        return function(directory) {
          if (directory == null) {
            return;
          }
          return _this.readMetadata(directory, function(error, metadata) {
            if (_this.isAtomPackage(metadata) || _this.isAtomCore(metadata)) {
              return _this.packageDirectories.push(directory);
            }
          });
        };
      })(this));
    },
    readMetadata: function(directory, callback) {
      return fs.readFile(path.join(directory.getPath(), 'package.json'), function(error, contents) {
        var metadata, parseError;
        if (error == null) {
          try {
            metadata = JSON.parse(contents);
          } catch (error1) {
            parseError = error1;
            error = parseError;
          }
        }
        return callback(error, metadata);
      });
    },
    isAtomPackage: function(metadata) {
      var ref, ref1;
      return (metadata != null ? (ref = metadata.engines) != null ? (ref1 = ref.atom) != null ? ref1.length : void 0 : void 0 : void 0) > 0;
    },
    isAtomCore: function(metadata) {
      return (metadata != null ? metadata.name : void 0) === 'atom';
    },
    isEditingAnAtomPackageFile: function(editor) {
      var directory, editorPath, i, len, parsedPath, ref, ref1;
      editorPath = editor.getPath();
      if (editorPath != null) {
        parsedPath = path.parse(editorPath);
        if (path.basename(parsedPath.dir) === '.atom') {
          if (parsedPath.base === 'init.coffee' || parsedPath.base === 'init.js') {
            return true;
          }
        }
      }
      ref1 = (ref = this.packageDirectories) != null ? ref : [];
      for (i = 0, len = ref1.length; i < len; i++) {
        directory = ref1[i];
        if (directory.contains(editorPath)) {
          return true;
        }
      }
      return false;
    },
    loadCompletions: function() {
      if (this.completions == null) {
        this.completions = {};
      }
      return this.loadProperty('atom', 'AtomEnvironment', CLASSES);
    },
    getCompletions: function(line) {
      var completion, completions, i, len, match, prefix, property, propertyCompletions, ref, ref1, ref2, ref3, segments;
      completions = [];
      match = (ref = propertyPrefixPattern.exec(line)) != null ? ref[1] : void 0;
      if (!match) {
        return completions;
      }
      segments = match.split('.');
      prefix = (ref1 = segments.pop()) != null ? ref1 : '';
      segments = segments.filter(function(segment) {
        return segment;
      });
      property = segments[segments.length - 1];
      propertyCompletions = (ref2 = (ref3 = this.completions[property]) != null ? ref3.completions : void 0) != null ? ref2 : [];
      for (i = 0, len = propertyCompletions.length; i < len; i++) {
        completion = propertyCompletions[i];
        if (!prefix || firstCharsEqual(completion.name, prefix)) {
          completions.push(clone(completion));
        }
      }
      return completions;
    },
    getPropertyClass: function(name) {
      var ref, ref1;
      return (ref = atom[name]) != null ? (ref1 = ref.constructor) != null ? ref1.name : void 0 : void 0;
    },
    loadProperty: function(propertyName, className, classes, parent) {
      var classCompletions, completion, i, len, propertyClass;
      classCompletions = classes[className];
      if (classCompletions == null) {
        return;
      }
      this.completions[propertyName] = {
        completions: []
      };
      for (i = 0, len = classCompletions.length; i < len; i++) {
        completion = classCompletions[i];
        this.completions[propertyName].completions.push(completion);
        if (completion.type === 'property') {
          propertyClass = this.getPropertyClass(completion.name);
          this.loadProperty(completion.name, propertyClass, classes);
        }
      }
    }
  };

  clone = function(obj) {
    var k, newObj, v;
    newObj = {};
    for (k in obj) {
      v = obj[k];
      newObj[k] = v;
    }
    return newObj;
  };

  firstCharsEqual = function(str1, str2) {
    return str1[0].toLowerCase() === str2[0].toLowerCase();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
