/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Directive, Input, ComponentFactoryResolver, ViewContainerRef, TemplateRef, Renderer2 } from '@angular/core';
import { BlockUIContentComponent } from '../components/block-ui-content/block-ui-content.component';
import { BlockUIInstanceService } from '../services/block-ui-instance.service';
import { BlockUIDefaultName } from '../constants/block-ui-default-name.constant';
var BlockUIDirective = /** @class */ (function () {
    function BlockUIDirective(blockUIService, viewRef, templateRef, renderer, componentFactoryResolver) {
        this.blockUIService = blockUIService;
        this.viewRef = viewRef;
        this.templateRef = templateRef;
        this.renderer = renderer;
        this.componentFactoryResolver = componentFactoryResolver;
    }
    Object.defineProperty(BlockUIDirective.prototype, "blockUI", {
        set: /**
         * @param {?} name
         * @return {?}
         */
        function (name) { this.blockTarget = name; },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(BlockUIDirective.prototype, "blockUIMessage", {
        set: /**
         * @param {?} message
         * @return {?}
         */
        function (message) { this.message = message; },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(BlockUIDirective.prototype, "blockUITemplate", {
        set: /**
         * @param {?} template
         * @return {?}
         */
        function (template) { this.template = template; },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStart", {
        set: /**
         * @param {?} delayStart
         * @return {?}
         */
        function (delayStart) {
            this.delayStart = delayStart ? Number(delayStart) : null;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStop", {
        set: /**
         * @param {?} delayStop
         * @return {?}
         */
        function (delayStop) {
            this.delayStop = delayStop ? Number(delayStop) : null;
        },
        enumerable: true,
        configurable: true
    });
    ;
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        try {
            this.viewRef.createEmbeddedView(this.templateRef);
            var /** @type {?} */ parentElement = this.viewRef.element.nativeElement.nextSibling;
            if (parentElement && !this.isComponentInTemplate(parentElement)) {
                this.renderer.addClass(parentElement, 'block-ui__element');
                this.blockUIComponentRef = this.createComponent();
                var /** @type {?} */ blockUIContent = this.findContentNode(this.viewRef.element.nativeElement);
                if (blockUIContent) {
                    var /** @type {?} */ settings = this.blockUIService.getSettings();
                    parentElement.appendChild(blockUIContent);
                    this.blockUIComponentRef.instance.className = 'block-ui-wrapper--element';
                    this.blockUIComponentRef.instance.name = this.blockTarget || BlockUIDefaultName;
                    if (this.message)
                        this.blockUIComponentRef.instance.defaultMessage = this.message;
                    if (this.delayStart)
                        this.blockUIComponentRef.instance.delayStart = this.delayStart;
                    if (this.delayStop)
                        this.blockUIComponentRef.instance.delayStop = this.delayStop;
                    if (this.template || settings.template)
                        this.blockUIComponentRef.instance.templateCmp = this.template || settings.template;
                }
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.isComponentInTemplate = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var children = (element || []).children;
        children = Array.from(children).reverse();
        return children.some(function (el) { return el.localName === 'block-ui'; });
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.findContentNode = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var nextSibling = element.nextSibling;
        return [nextSibling, nextSibling.nextSibling].find(function (e) { return e.localName === 'block-ui-content'; });
    };
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.createComponent = /**
     * @return {?}
     */
    function () {
        var /** @type {?} */ resolvedBlockUIComponent = this.componentFactoryResolver.resolveComponentFactory(BlockUIContentComponent);
        return this.viewRef.createComponent(resolvedBlockUIComponent);
    };
    BlockUIDirective.decorators = [
        { type: Directive, args: [{ selector: '[blockUI]' },] },
    ];
    /** @nocollapse */
    BlockUIDirective.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ViewContainerRef },
        { type: TemplateRef },
        { type: Renderer2 },
        { type: ComponentFactoryResolver }
    ]; };
    BlockUIDirective.propDecorators = {
        blockUI: [{ type: Input }],
        blockUIMessage: [{ type: Input }],
        blockUITemplate: [{ type: Input }],
        blockUIDelayStart: [{ type: Input }],
        blockUIDelayStop: [{ type: Input }]
    };
    return BlockUIDirective;
}());
export { BlockUIDirective };
function BlockUIDirective_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIDirective.prototype.blockUIComponentRef;
    /** @type {?} */
    BlockUIDirective.prototype.blockTarget;
    /** @type {?} */
    BlockUIDirective.prototype.message;
    /** @type {?} */
    BlockUIDirective.prototype.template;
    /** @type {?} */
    BlockUIDirective.prototype.delayStart;
    /** @type {?} */
    BlockUIDirective.prototype.delayStop;
    /** @type {?} */
    BlockUIDirective.prototype.blockUIService;
    /** @type {?} */
    BlockUIDirective.prototype.viewRef;
    /** @type {?} */
    BlockUIDirective.prototype.templateRef;
    /** @type {?} */
    BlockUIDirective.prototype.renderer;
    /** @type {?} */
    BlockUIDirective.prototype.componentFactoryResolver;
}

//# sourceMappingURL=data:application/json;base64,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