/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { NgModule, InjectionToken } from '@angular/core';
import { CommonModule } from '@angular/common';
import { BlockUIComponent } from './components/block-ui/block-ui.component';
import { BlockUIContentComponent } from './components/block-ui-content/block-ui-content.component';
import { BlockUIInstanceService } from './services/block-ui-instance.service';
import { BlockUIService } from './services/block-ui.service';
import { BlockUIDirective } from './directives/block-ui.directive';
export var /** @type {?} */ BlockUIServiceInstance = new BlockUIInstanceService();
// Needed for AOT compiling
export var /** @type {?} */ BlockUIModuleSettings = new InjectionToken('BlockUIModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
export function provideInstance(settings) {
    BlockUIServiceInstance.updateSettings(settings);
    return BlockUIServiceInstance;
}
var BlockUIModule = /** @class */ (function () {
    function BlockUIModule() {
    }
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIModule.forRoot = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        return {
            ngModule: BlockUIModule,
            providers: [
                {
                    provide: BlockUIModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIInstanceService,
                    useFactory: provideInstance,
                    deps: [BlockUIModuleSettings]
                },
                BlockUIService
            ]
        };
    };
    BlockUIModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule
                    ],
                    entryComponents: [
                        BlockUIComponent,
                        BlockUIContentComponent
                    ],
                    declarations: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ],
                    exports: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ]
                },] },
    ];
    return BlockUIModule;
}());
export { BlockUIModule };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmxvY2stdWkubW9kdWxlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vbmctYmxvY2stdWkvIiwic291cmNlcyI6WyJibG9jay11aS5tb2R1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxRQUFRLEVBQXVCLGNBQWMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUM5RSxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFFL0MsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sMENBQTBDLENBQUM7QUFDNUUsT0FBTyxFQUFFLHVCQUF1QixFQUFFLE1BQU0sMERBQTBELENBQUM7QUFDbkcsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sc0NBQXNDLENBQUM7QUFDOUUsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLDZCQUE2QixDQUFDO0FBQzdELE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLGlDQUFpQyxDQUFDO0FBR25FLE1BQU0sQ0FBQyxxQkFBTSxzQkFBc0IsR0FBRyxJQUFJLHNCQUFzQixFQUFFLENBQUM7O0FBR25FLE1BQU0sQ0FBQyxxQkFBTSxxQkFBcUIsR0FBRyxJQUFJLGNBQWMsQ0FBUyx1QkFBdUIsQ0FBQyxDQUFDOzs7OztBQUV6RixNQUFNLDBCQUEwQixRQUF5QjtJQUN2RCxzQkFBc0IsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDaEQsTUFBTSxDQUFDLHNCQUFzQixDQUFDO0NBQy9COzs7Ozs7OztJQXNCZSxxQkFBTzs7OztjQUFDLFFBQThCO1FBQTlCLHlCQUFBLEVBQUEsYUFBOEI7UUFDbEQsTUFBTSxDQUFDO1lBQ0wsUUFBUSxFQUFFLGFBQWE7WUFDdkIsU0FBUyxFQUFFO2dCQUNUO29CQUNFLE9BQU8sRUFBRSxxQkFBcUI7b0JBQzlCLFFBQVEsRUFBRSxRQUFRO2lCQUNuQjtnQkFDRDtvQkFDRSxPQUFPLEVBQUUsc0JBQXNCO29CQUMvQixVQUFVLEVBQUUsZUFBZTtvQkFDM0IsSUFBSSxFQUFFLENBQUMscUJBQXFCLENBQUM7aUJBQzlCO2dCQUNELGNBQWM7YUFDZjtTQUNGLENBQUM7OztnQkFuQ0wsUUFBUSxTQUFDO29CQUNSLE9BQU8sRUFBRTt3QkFDUCxZQUFZO3FCQUNiO29CQUNELGVBQWUsRUFBRTt3QkFDZixnQkFBZ0I7d0JBQ2hCLHVCQUF1QjtxQkFDeEI7b0JBQ0QsWUFBWSxFQUFFO3dCQUNaLGdCQUFnQjt3QkFDaEIsZ0JBQWdCO3dCQUNoQix1QkFBdUI7cUJBQ3hCO29CQUNELE9BQU8sRUFBRTt3QkFDUCxnQkFBZ0I7d0JBQ2hCLGdCQUFnQjt3QkFDaEIsdUJBQXVCO3FCQUN4QjtpQkFDRjs7d0JBdENEOztTQXVDYSxhQUFhIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTmdNb2R1bGUsIE1vZHVsZVdpdGhQcm92aWRlcnMsIEluamVjdGlvblRva2VuIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBDb21tb25Nb2R1bGUgfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xuXG5pbXBvcnQgeyBCbG9ja1VJQ29tcG9uZW50IH0gZnJvbSAnLi9jb21wb25lbnRzL2Jsb2NrLXVpL2Jsb2NrLXVpLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBCbG9ja1VJQ29udGVudENvbXBvbmVudCB9IGZyb20gJy4vY29tcG9uZW50cy9ibG9jay11aS1jb250ZW50L2Jsb2NrLXVpLWNvbnRlbnQuY29tcG9uZW50JztcbmltcG9ydCB7IEJsb2NrVUlJbnN0YW5jZVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2VzL2Jsb2NrLXVpLWluc3RhbmNlLnNlcnZpY2UnO1xuaW1wb3J0IHsgQmxvY2tVSVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2VzL2Jsb2NrLXVpLnNlcnZpY2UnO1xuaW1wb3J0IHsgQmxvY2tVSURpcmVjdGl2ZSB9IGZyb20gJy4vZGlyZWN0aXZlcy9ibG9jay11aS5kaXJlY3RpdmUnO1xuaW1wb3J0IHsgQmxvY2tVSVNldHRpbmdzIH0gZnJvbSAnLi9tb2RlbHMvYmxvY2stdWktc2V0dGluZ3MubW9kZWwnO1xuXG5leHBvcnQgY29uc3QgQmxvY2tVSVNlcnZpY2VJbnN0YW5jZSA9IG5ldyBCbG9ja1VJSW5zdGFuY2VTZXJ2aWNlKCk7XG5cbi8vIE5lZWRlZCBmb3IgQU9UIGNvbXBpbGluZ1xuZXhwb3J0IGNvbnN0IEJsb2NrVUlNb2R1bGVTZXR0aW5ncyA9IG5ldyBJbmplY3Rpb25Ub2tlbjxzdHJpbmc+KCdCbG9ja1VJTW9kdWxlU2V0dGluZ3MnKTtcblxuZXhwb3J0IGZ1bmN0aW9uIHByb3ZpZGVJbnN0YW5jZShzZXR0aW5nczogQmxvY2tVSVNldHRpbmdzKTogYW55IHtcbiAgQmxvY2tVSVNlcnZpY2VJbnN0YW5jZS51cGRhdGVTZXR0aW5ncyhzZXR0aW5ncyk7XG4gIHJldHVybiBCbG9ja1VJU2VydmljZUluc3RhbmNlO1xufVxuXG5ATmdNb2R1bGUoe1xuICBpbXBvcnRzOiBbXG4gICAgQ29tbW9uTW9kdWxlXG4gIF0sXG4gIGVudHJ5Q29tcG9uZW50czogW1xuICAgIEJsb2NrVUlDb21wb25lbnQsXG4gICAgQmxvY2tVSUNvbnRlbnRDb21wb25lbnRcbiAgXSxcbiAgZGVjbGFyYXRpb25zOiBbXG4gICAgQmxvY2tVSUNvbXBvbmVudCxcbiAgICBCbG9ja1VJRGlyZWN0aXZlLFxuICAgIEJsb2NrVUlDb250ZW50Q29tcG9uZW50XG4gIF0sXG4gIGV4cG9ydHM6IFtcbiAgICBCbG9ja1VJQ29tcG9uZW50LFxuICAgIEJsb2NrVUlEaXJlY3RpdmUsXG4gICAgQmxvY2tVSUNvbnRlbnRDb21wb25lbnRcbiAgXVxufSlcbmV4cG9ydCBjbGFzcyBCbG9ja1VJTW9kdWxlIHtcbiAgcHVibGljIHN0YXRpYyBmb3JSb290KHNldHRpbmdzOiBCbG9ja1VJU2V0dGluZ3MgPSB7fSk6IE1vZHVsZVdpdGhQcm92aWRlcnMge1xuICAgIHJldHVybiB7XG4gICAgICBuZ01vZHVsZTogQmxvY2tVSU1vZHVsZSxcbiAgICAgIHByb3ZpZGVyczogW1xuICAgICAgICB7XG4gICAgICAgICAgcHJvdmlkZTogQmxvY2tVSU1vZHVsZVNldHRpbmdzLFxuICAgICAgICAgIHVzZVZhbHVlOiBzZXR0aW5nc1xuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgcHJvdmlkZTogQmxvY2tVSUluc3RhbmNlU2VydmljZSxcbiAgICAgICAgICB1c2VGYWN0b3J5OiBwcm92aWRlSW5zdGFuY2UsXG4gICAgICAgICAgZGVwczogW0Jsb2NrVUlNb2R1bGVTZXR0aW5nc11cbiAgICAgICAgfSxcbiAgICAgICAgQmxvY2tVSVNlcnZpY2VcbiAgICAgIF1cbiAgICB9O1xuICB9XG59XG4iXX0=