/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { NgModule, InjectionToken } from '@angular/core';
import { CommonModule } from '@angular/common';
import { BlockUIComponent } from './components/block-ui/block-ui.component';
import { BlockUIContentComponent } from './components/block-ui-content/block-ui-content.component';
import { BlockUIInstanceService } from './services/block-ui-instance.service';
import { BlockUIService } from './services/block-ui.service';
import { BlockUIDirective } from './directives/block-ui.directive';
export const /** @type {?} */ BlockUIServiceInstance = new BlockUIInstanceService();
// Needed for AOT compiling
export const /** @type {?} */ BlockUIModuleSettings = new InjectionToken('BlockUIModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
export function provideInstance(settings) {
    BlockUIServiceInstance.updateSettings(settings);
    return BlockUIServiceInstance;
}
export class BlockUIModule {
    /**
     * @param {?=} settings
     * @return {?}
     */
    static forRoot(settings = {}) {
        return {
            ngModule: BlockUIModule,
            providers: [
                {
                    provide: BlockUIModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIInstanceService,
                    useFactory: provideInstance,
                    deps: [BlockUIModuleSettings]
                },
                BlockUIService
            ]
        };
    }
}
BlockUIModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    CommonModule
                ],
                entryComponents: [
                    BlockUIComponent,
                    BlockUIContentComponent
                ],
                declarations: [
                    BlockUIComponent,
                    BlockUIDirective,
                    BlockUIContentComponent
                ],
                exports: [
                    BlockUIComponent,
                    BlockUIDirective,
                    BlockUIContentComponent
                ]
            },] },
];

//# sourceMappingURL=data:application/json;base64,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