"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tasks_1 = require("@angular-devkit/schematics/tasks");
const dependencies_1 = require("../../utility/dependencies");
const latest_versions_1 = require("../../utility/latest-versions");
var polyfill_metadata_1 = require("./polyfill-metadata");
exports.polyfillMetadataRule = polyfill_metadata_1.polyfillMetadataRule;
var typescript_helpers_1 = require("./typescript-helpers");
exports.typeScriptHelpersRule = typescript_helpers_1.typeScriptHelpersRule;
var devkit_ng_packagr_1 = require("./devkit-ng-packagr");
exports.updateDevkitBuildNgPackagr = devkit_ng_packagr_1.updateDevkitBuildNgPackagr;
function default_1() {
    return (tree, context) => {
        const existing = dependencies_1.getPackageJsonDependency(tree, '@angular-devkit/build-angular');
        if (existing && latest_versions_1.latestVersions.DevkitBuildAngular === existing.version) {
            return;
        }
        const type = existing ? existing.type : dependencies_1.NodeDependencyType.Dev;
        dependencies_1.addPackageJsonDependency(tree, {
            type,
            name: '@angular-devkit/build-angular',
            version: latest_versions_1.latestVersions.DevkitBuildAngular,
            overwrite: true,
        });
        context.addTask(new tasks_1.NodePackageInstallTask());
    };
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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