/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
/**
 * Inject decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Inject = makeParamDecorator('Inject', function (token) { return ({ token: token }); });
/**
 * Optional decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Optional = makeParamDecorator('Optional');
/**
 * Self decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Self = makeParamDecorator('Self');
/**
 * SkipSelf decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var SkipSelf = makeParamDecorator('SkipSelf');
/**
 * Host decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Host = makeParamDecorator('Host');
//# sourceMappingURL=data:application/json;base64,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