/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { compileInjectable as render3CompileInjectable } from '../render3/jit/injectable';
import { makeDecorator } from '../util/decorators';
import { defineInjectable, getInjectableDef } from './defs';
import { convertInjectableProviderToFactory } from './util';
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Injectable = makeDecorator('Injectable', undefined, undefined, undefined, function (type, meta) { return SWITCH_COMPILE_INJECTABLE(type, meta); });
/**
 * Supports @Injectable() in JIT mode for Render2.
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        injectableType.ngInjectableDef = defineInjectable({
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
export var SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
var SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
var SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
//# sourceMappingURL=data:application/json;base64,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