/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
/**
 * Type of the Inject decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function InjectDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Inject decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Inject = makeParamDecorator('Inject', (token) => ({ token }));
/**
 * Type of the Optional decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function OptionalDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Optional decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Optional = makeParamDecorator('Optional');
/**
 * Type of the Self decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function SelfDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Self decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Self = makeParamDecorator('Self');
/**
 * Type of the SkipSelf decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function SkipSelfDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * SkipSelf decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const SkipSelf = makeParamDecorator('SkipSelf');
/**
 * Type of the Host decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function HostDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Host decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Host = makeParamDecorator('Host');
//# sourceMappingURL=data:application/json;base64,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