/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

final class NativeString
extends IdScriptable {
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_charAt = 6;
    private static final int Id_charCodeAt = 7;
    private static final int Id_indexOf = 8;
    private static final int Id_lastIndexOf = 9;
    private static final int Id_split = 10;
    private static final int Id_substring = 11;
    private static final int Id_toLowerCase = 12;
    private static final int Id_toUpperCase = 13;
    private static final int Id_substr = 14;
    private static final int Id_concat = 15;
    private static final int Id_slice = 16;
    private static final int Id_bold = 17;
    private static final int Id_italics = 18;
    private static final int Id_fixed = 19;
    private static final int Id_strike = 20;
    private static final int Id_small = 21;
    private static final int Id_big = 22;
    private static final int Id_blink = 23;
    private static final int Id_sup = 24;
    private static final int Id_sub = 25;
    private static final int Id_fontsize = 26;
    private static final int Id_fontcolor = 27;
    private static final int Id_link = 28;
    private static final int Id_anchor = 29;
    private static final int Id_equals = 30;
    private static final int Id_equalsIgnoreCase = 31;
    private static final int Id_match = 32;
    private static final int Id_search = 33;
    private static final int Id_replace = 34;
    private static final int MAX_PROTOTYPE_ID = 34;
    private String string;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeString obj = new NativeString("");
        obj.prototypeFlag = true;
        obj.addAsPrototype(34, cx, scope, sealed);
    }

    private NativeString(String s) {
        this.setMaxId(1);
        this.string = s;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        this.addIdFunctionProperty(ctor, -1, sealed);
        super.fillConstructorProperties(cx, ctor, sealed);
    }

    @Override
    protected int getIdAttributes(int id) {
        if (id == 1) {
            return 7;
        }
        return super.getIdAttributes(id);
    }

    @Override
    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.wrap_int(this.string.length());
        }
        return super.getIdValue(id);
    }

    @Override
    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 2;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 0;
                }
                case 14: {
                    return 2;
                }
                case 15: {
                    return 1;
                }
                case 16: {
                    return 2;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 0;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 1;
                }
                case 33: {
                    return 1;
                }
                case 34: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    @Override
    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -1: {
                    int N = args.length;
                    if (N < 1) {
                        return "";
                    }
                    StringBuffer sb = new StringBuffer(N);
                    for (int i = 0; i != N; ++i) {
                        sb.append(ScriptRuntime.toUint16(args[i]));
                    }
                    return sb.toString();
                }
                case 2: {
                    String s;
                    String string = s = args.length >= 1 ? ScriptRuntime.toString(args[0]) : "";
                    if (thisObj == null) {
                        return new NativeString(s);
                    }
                    return s;
                }
                case 3: 
                case 5: {
                    return NativeString.realThis((Scriptable)thisObj, (IdFunction)f).string;
                }
                case 4: {
                    String s = NativeString.realThis((Scriptable)thisObj, (IdFunction)f).string;
                    return "(new String(\"" + ScriptRuntime.escapeString(s) + "\"))";
                }
                case 6: 
                case 7: {
                    String target = ScriptRuntime.toString(thisObj);
                    double pos = ScriptRuntime.toInteger(args, 0);
                    if (pos < 0.0 || pos >= (double)target.length()) {
                        if (methodId == 6) {
                            return "";
                        }
                        return ScriptRuntime.NaNobj;
                    }
                    char c = target.charAt((int)pos);
                    if (methodId == 6) {
                        return String.valueOf(c);
                    }
                    return this.wrap_int(c);
                }
                case 8: {
                    return this.wrap_int(NativeString.js_indexOf(ScriptRuntime.toString(thisObj), args));
                }
                case 9: {
                    return this.wrap_int(NativeString.js_lastIndexOf(ScriptRuntime.toString(thisObj), args));
                }
                case 10: {
                    return NativeString.js_split(cx, scope, ScriptRuntime.toString(thisObj), args);
                }
                case 11: {
                    return NativeString.js_substring(cx, ScriptRuntime.toString(thisObj), args);
                }
                case 12: {
                    return ScriptRuntime.toString(thisObj).toLowerCase();
                }
                case 13: {
                    return ScriptRuntime.toString(thisObj).toUpperCase();
                }
                case 14: {
                    return NativeString.js_substr(ScriptRuntime.toString(thisObj), args);
                }
                case 15: {
                    return NativeString.js_concat(ScriptRuntime.toString(thisObj), args);
                }
                case 16: {
                    return NativeString.js_slice(ScriptRuntime.toString(thisObj), args);
                }
                case 17: {
                    return NativeString.tagify(thisObj, "b", null, null);
                }
                case 18: {
                    return NativeString.tagify(thisObj, "i", null, null);
                }
                case 19: {
                    return NativeString.tagify(thisObj, "tt", null, null);
                }
                case 20: {
                    return NativeString.tagify(thisObj, "strike", null, null);
                }
                case 21: {
                    return NativeString.tagify(thisObj, "small", null, null);
                }
                case 22: {
                    return NativeString.tagify(thisObj, "big", null, null);
                }
                case 23: {
                    return NativeString.tagify(thisObj, "blink", null, null);
                }
                case 24: {
                    return NativeString.tagify(thisObj, "sup", null, null);
                }
                case 25: {
                    return NativeString.tagify(thisObj, "sub", null, null);
                }
                case 26: {
                    return NativeString.tagify(thisObj, "font", "size", args);
                }
                case 27: {
                    return NativeString.tagify(thisObj, "font", "color", args);
                }
                case 28: {
                    return NativeString.tagify(thisObj, "a", "href", args);
                }
                case 29: {
                    return NativeString.tagify(thisObj, "a", "name", args);
                }
                case 30: 
                case 31: {
                    String s1 = ScriptRuntime.toString(thisObj);
                    String s2 = ScriptRuntime.toString(args, 0);
                    return this.wrap_boolean(methodId == 30 ? s1.equals(s2) : s1.equalsIgnoreCase(s2));
                }
                case 32: {
                    return ScriptRuntime.checkRegExpProxy(cx).match(cx, scope, thisObj, args);
                }
                case 33: {
                    return ScriptRuntime.checkRegExpProxy(cx).search(cx, scope, thisObj, args);
                }
                case 34: {
                    return ScriptRuntime.checkRegExpProxy(cx).replace(cx, scope, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static NativeString realThis(Scriptable thisObj, IdFunction f) {
        if (!(thisObj instanceof NativeString)) {
            throw NativeString.incompatibleCallError(f);
        }
        return (NativeString)thisObj;
    }

    private static String tagify(Object thisObj, String tag, String attribute, Object[] args) {
        String str = ScriptRuntime.toString(thisObj);
        StringBuffer result = new StringBuffer();
        result.append('<');
        result.append(tag);
        if (attribute != null) {
            result.append(' ');
            result.append(attribute);
            result.append("=\"");
            result.append(ScriptRuntime.toString(args, 0));
            result.append('\"');
        }
        result.append('>');
        result.append(str);
        result.append("</");
        result.append(tag);
        result.append('>');
        return result.toString();
    }

    public String toString() {
        return this.string;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.string.length()) {
            return this.string.substring(index, index + 1);
        }
        return super.get(index, start);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.string.length()) {
            return;
        }
        super.put(index, start, value);
    }

    private static int js_indexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double begin = ScriptRuntime.toInteger(args, 1);
        if (begin > (double)target.length()) {
            return -1;
        }
        if (begin < 0.0) {
            begin = 0.0;
        }
        return target.indexOf(search, (int)begin);
    }

    private static int js_lastIndexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double end = ScriptRuntime.toNumber(args, 1);
        if (end != end || end > (double)target.length()) {
            end = target.length();
        } else if (end < 0.0) {
            end = 0.0;
        }
        return target.lastIndexOf(search, (int)end);
    }

    private static int find_split(Context cx, Scriptable scope, String target, String separator, int version, RegExpProxy reProxy, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int i;
        int length = target.length();
        if (version == 120 && re == null && separator.length() == 1 && separator.charAt(0) == ' ') {
            int j;
            if (i == 0) {
                for (i = ip[0]; i < length && Character.isWhitespace(target.charAt(i)); ++i) {
                }
                ip[0] = i;
            }
            if (i == length) {
                return -1;
            }
            while (i < length && !Character.isWhitespace(target.charAt(i))) {
                ++i;
            }
            for (j = i; j < length && Character.isWhitespace(target.charAt(j)); ++j) {
            }
            matchlen[0] = j - i;
            return i;
        }
        if (i > length) {
            return -1;
        }
        if (re != null) {
            return reProxy.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (version != 0 && version < 130 && length == 0) {
            return -1;
        }
        if (separator.length() == 0) {
            if (version == 120) {
                if (i == length) {
                    matchlen[0] = 1;
                    return i;
                }
                return i + 1;
            }
            return i == length ? -1 : i + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i = target.indexOf(separator, ip[0]);
        return i != -1 ? i : length;
    }

    private static Object js_split(Context cx, Scriptable scope, String target, Object[] args) {
        int match;
        Scriptable test;
        Scriptable top = NativeString.getTopLevelScope(scope);
        Scriptable result = ScriptRuntime.newObject(cx, top, "Array", null);
        if (args.length < 1) {
            result.put(0, result, (Object)target);
            return result;
        }
        boolean limited = args.length > 1 && args[1] != Undefined.instance;
        long limit = 0L;
        if (limited && (limit = ScriptRuntime.toUint32(args[1])) > (long)target.length()) {
            limit = 1 + target.length();
        }
        String separator = null;
        int[] matchlen = new int[1];
        Scriptable re = null;
        RegExpProxy reProxy = null;
        if (args[0] instanceof Scriptable && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(test = (Scriptable)args[0])) {
            re = test;
        }
        if (re == null) {
            separator = ScriptRuntime.toString(args[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[]{0};
        int len = 0;
        boolean[] matched = new boolean[]{false};
        String[][] parens = new String[][]{null};
        int version = cx.getLanguageVersion();
        while (!((match = NativeString.find_split(cx, scope, target, separator, version, reProxy, re, ip, matchlen, matched, parens)) < 0 || limited && (long)len >= limit || match > target.length())) {
            String substr = target.length() == 0 ? target : target.substring(ip[0], match);
            result.put(len, result, (Object)substr);
            ++len;
            if (re != null && matched[0]) {
                int size = parens[0].length;
                for (int num = 0; !(num >= size || limited && (long)len >= limit); ++num) {
                    result.put(len, result, (Object)parens[0][num]);
                    ++len;
                }
                matched[0] = false;
            }
            ip[0] = match + matchlen[0];
            if (version >= 130 || version == 0 || limited || ip[0] != target.length()) continue;
            break;
        }
        return result;
    }

    private static String js_substring(Context cx, String target, Object[] args) {
        double end;
        int length = target.length();
        double start = ScriptRuntime.toInteger(args, 0);
        if (start < 0.0) {
            start = 0.0;
        } else if (start > (double)length) {
            start = length;
        }
        if (args.length <= 1 || args[1] == Undefined.instance) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            } else if (end > (double)length) {
                end = length;
            }
            if (end < start) {
                if (cx.getLanguageVersion() != 120) {
                    double temp = start;
                    start = end;
                    end = temp;
                } else {
                    end = start;
                }
            }
        }
        return target.substring((int)start, (int)end);
    }

    int getLength() {
        return this.string.length();
    }

    private static String js_substr(String target, Object[] args) {
        double end;
        if (args.length < 1) {
            return target;
        }
        double begin = ScriptRuntime.toInteger(args[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args.length == 1) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            }
            if ((end += begin) > (double)length) {
                end = length;
            }
        }
        return target.substring((int)begin, (int)end);
    }

    private static String js_concat(String target, Object[] args) {
        int N = args.length;
        if (N == 0) {
            return target;
        }
        if (N == 1) {
            String arg = ScriptRuntime.toString(args[0]);
            return target.concat(arg);
        }
        int size = target.length();
        String[] argsAsStrings = new String[N];
        for (int i = 0; i != N; ++i) {
            String s;
            argsAsStrings[i] = s = ScriptRuntime.toString(args[i]);
            size += s.length();
        }
        StringBuffer result = new StringBuffer(size);
        result.append(target);
        for (int i = 0; i != N; ++i) {
            result.append(argsAsStrings[i]);
        }
        return result.toString();
    }

    private static String js_slice(String target, Object[] args) {
        if (args.length != 0) {
            double end;
            double begin = ScriptRuntime.toInteger(args[0]);
            int length = target.length();
            if (begin < 0.0) {
                if ((begin += (double)length) < 0.0) {
                    begin = 0.0;
                }
            } else if (begin > (double)length) {
                begin = length;
            }
            if (args.length == 1) {
                end = length;
            } else {
                end = ScriptRuntime.toInteger(args[1]);
                if (end < 0.0) {
                    if ((end += (double)length) < 0.0) {
                        end = 0.0;
                    }
                } else if (end > (double)length) {
                    end = length;
                }
                if (end < begin) {
                    end = begin;
                }
            }
            return target.substring((int)begin, (int)end);
        }
        return target;
    }

    @Override
    protected String getIdName(int id) {
        if (id == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (id) {
                case -1: {
                    return "fromCharCode";
                }
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toSource";
                }
                case 5: {
                    return "valueOf";
                }
                case 6: {
                    return "charAt";
                }
                case 7: {
                    return "charCodeAt";
                }
                case 8: {
                    return "indexOf";
                }
                case 9: {
                    return "lastIndexOf";
                }
                case 10: {
                    return "split";
                }
                case 11: {
                    return "substring";
                }
                case 12: {
                    return "toLowerCase";
                }
                case 13: {
                    return "toUpperCase";
                }
                case 14: {
                    return "substr";
                }
                case 15: {
                    return "concat";
                }
                case 16: {
                    return "slice";
                }
                case 17: {
                    return "bold";
                }
                case 18: {
                    return "italics";
                }
                case 19: {
                    return "fixed";
                }
                case 20: {
                    return "strike";
                }
                case 21: {
                    return "small";
                }
                case 22: {
                    return "big";
                }
                case 23: {
                    return "blink";
                }
                case 24: {
                    return "sup";
                }
                case 25: {
                    return "sub";
                }
                case 26: {
                    return "fontsize";
                }
                case 27: {
                    return "fontcolor";
                }
                case 28: {
                    return "link";
                }
                case 29: {
                    return "anchor";
                }
                case 30: {
                    return "equals";
                }
                case 31: {
                    return "equalsIgnoreCase";
                }
                case 32: {
                    return "match";
                }
                case 33: {
                    return "search";
                }
                case 34: {
                    return "replace";
                }
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String s) {
        if (s.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeString.toPrototypeId(s);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(2);
                if (c == 'b') {
                    if (s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                    return 25;
                }
                if (c == 'g') {
                    if (s.charAt(0) != 'b' || s.charAt(1) != 'i') break;
                    return 22;
                }
                if (c != 'p' || s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                return 24;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'b') {
                    X = "bold";
                    id = 17;
                    break;
                }
                if (c != 'l') break;
                X = "link";
                id = 28;
                break;
            }
            case 5: {
                switch (s.charAt(4)) {
                    case 'd': {
                        X = "fixed";
                        id = 19;
                        break block0;
                    }
                    case 'e': {
                        X = "slice";
                        id = 16;
                        break block0;
                    }
                    case 'h': {
                        X = "match";
                        id = 32;
                        break block0;
                    }
                    case 'k': {
                        X = "blink";
                        id = 23;
                        break block0;
                    }
                    case 'l': {
                        X = "small";
                        id = 21;
                        break block0;
                    }
                    case 't': {
                        X = "split";
                        id = 10;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'e': {
                        X = "search";
                        id = 33;
                        break block0;
                    }
                    case 'h': {
                        X = "charAt";
                        id = 6;
                        break block0;
                    }
                    case 'n': {
                        X = "anchor";
                        id = 29;
                        break block0;
                    }
                    case 'o': {
                        X = "concat";
                        id = 15;
                        break block0;
                    }
                    case 'q': {
                        X = "equals";
                        id = 30;
                        break block0;
                    }
                    case 't': {
                        X = "strike";
                        id = 20;
                        break block0;
                    }
                    case 'u': {
                        X = "substr";
                        id = 14;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "valueOf";
                        id = 5;
                        break block0;
                    }
                    case 'e': {
                        X = "replace";
                        id = 34;
                        break block0;
                    }
                    case 'n': {
                        X = "indexOf";
                        id = 8;
                        break block0;
                    }
                    case 't': {
                        X = "italics";
                        id = 18;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(4);
                if (c == 'r') {
                    X = "toString";
                    id = 3;
                    break;
                }
                if (c == 's') {
                    X = "fontsize";
                    id = 26;
                    break;
                }
                if (c != 'u') break;
                X = "toSource";
                id = 4;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "fontcolor";
                    id = 27;
                    break;
                }
                if (c != 's') break;
                X = "substring";
                id = 11;
                break;
            }
            case 10: {
                X = "charCodeAt";
                id = 7;
                break;
            }
            case 11: {
                switch (s.charAt(2)) {
                    case 'L': {
                        X = "toLowerCase";
                        id = 12;
                        break block0;
                    }
                    case 'U': {
                        X = "toUpperCase";
                        id = 13;
                        break block0;
                    }
                    case 'n': {
                        X = "constructor";
                        id = 2;
                        break block0;
                    }
                    case 's': {
                        X = "lastIndexOf";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                X = "equalsIgnoreCase";
                id = 31;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

