"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("./options");
class TslintFixTask {
    constructor(configOrPath, options) {
        if (options) {
            this._configOrPath = configOrPath;
            this._options = options;
        }
        else {
            this._options = configOrPath;
            this._configOrPath = null;
        }
    }
    toConfiguration() {
        const path = typeof this._configOrPath == 'string' ? { tslintPath: this._configOrPath } : {};
        const config = typeof this._configOrPath == 'object' && this._configOrPath !== null
            ? { tslintConfig: this._configOrPath }
            : {};
        const options = Object.assign({}, this._options, path, config);
        return { name: options_1.TslintFixName, options };
    }
}
exports.TslintFixTask = TslintFixTask;
//# sourceMappingURL=data:application/json;base64,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