/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.MacOSXWatchService;
import com.swoval.files.RegisterableWatchService;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;

public class RegisterableWatchServices {
    public static RegisterableWatchService get() throws IOException, InterruptedException {
        return Platform.isMac() ? new MacOSXWatchService() : new RegisterableWatchServiceImpl();
    }

    static class RegisterableWatchServiceImpl
    implements WatchService,
    RegisterableWatchService {
        private final WatchService watchService;

        RegisterableWatchServiceImpl(WatchService watchService) {
            this.watchService = watchService;
        }

        RegisterableWatchServiceImpl() throws IOException {
            this(FileSystems.getDefault().newWatchService());
        }

        @Override
        public WatchKey register(Path path, WatchEvent.Kind<?> ... kindArray) throws IOException {
            return this.watchService instanceof RegisterableWatchService ? ((RegisterableWatchService)this.watchService).register(path, kindArray) : path.register(this.watchService, kindArray);
        }

        @Override
        public void close() throws IOException {
            this.watchService.close();
        }

        @Override
        public WatchKey poll() {
            return this.watchService.poll();
        }

        @Override
        public WatchKey poll(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.watchService.poll(l, timeUnit);
        }

        @Override
        public WatchKey take() throws InterruptedException {
            return this.watchService.take();
        }
    }
}

