/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.tools.ant.BuildException;

public class IvyFindRevision
extends IvyTask {
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String property = "ivy.revision";

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    @Override
    public void doExecute() throws BuildException {
        ResolvedModuleRevision resolvedModuleRevision;
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy findrevision task");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy findrevision task");
        }
        if (this.revision == null) {
            throw new BuildException("no revision provided for ivy findrevision task");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        if (this.branch == null) {
            this.branch = ivySettings.getDefaultBranch(new ModuleId(this.organisation, this.module));
        }
        if ((resolvedModuleRevision = ivy.findModule(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision))) != null) {
            this.getProject().setProperty(this.property, resolvedModuleRevision.getId().getRevision());
        }
    }
}

