/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import icons.ImagesIcons;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.jetbrains.annotations.NotNull;

final class ImageFileTypeManagerImpl
extends ImageFileTypeManager {
    private static final String IMAGE_FILE_TYPE_NAME = "Image";
    private static final String IMAGE_FILE_TYPE_DESCRIPTION = ImagesBundle.message("images.filetype.description", new Object[0]);
    private static final UserFileType IMAGE_FILE_TYPE = new ImageFileType();

    ImageFileTypeManagerImpl() {
    }

    @Override
    public boolean isImage(@NotNull VirtualFile file) {
        if (file == null) {
            ImageFileTypeManagerImpl.$$$reportNull$$$0(0);
        }
        return file.getFileType() == IMAGE_FILE_TYPE || file.getFileType() instanceof SvgFileType;
    }

    @Override
    @NotNull
    public FileType getImageFileType() {
        UserFileType userFileType = IMAGE_FILE_TYPE;
        if (userFileType == null) {
            ImageFileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        return userFileType;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            ImageFileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        THashSet processed = new THashSet();
        for (String format : ImageIO.getReaderFormatNames()) {
            processed.add(StringUtil.toLowerCase((String)format));
        }
        processed.add(StringUtil.toLowerCase((String)"ico"));
        consumer.consume((FileType)IMAGE_FILE_TYPE, StringUtil.join((Collection)processed, (String)";"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/fileTypes/impl/ImageFileTypeManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/fileTypes/impl/ImageFileTypeManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImage";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFileTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ImageFileType
    extends UserBinaryFileType {
        private ImageFileType() {
            this.setName(ImageFileTypeManagerImpl.IMAGE_FILE_TYPE_NAME);
            this.setDescription(IMAGE_FILE_TYPE_DESCRIPTION);
        }

        public Icon getIcon() {
            return ImagesIcons.ImagesFileType;
        }
    }
}

