/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import gnu.trove.TLongObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
    private final Executor myQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RefreshQueue Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final ExecutorService myEventProcessingQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Async Refresh Event Processing", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(VfsBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
    private int myBusyThreads = 0;
    private final TLongObjectHashMap<RefreshSession> mySessions = new TLongObjectHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);
    private final AtomicLong myWriteActionCounter = new AtomicLong();

    public RefreshQueueImpl() {
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionStarted(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                RefreshQueueImpl.this.myWriteActionCounter.incrementAndGet();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl$1", "writeActionStarted"));
            }
        }, (Disposable)this);
    }

    public void execute(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(0);
        }
        if (session2.isAsynchronous()) {
            this.queueSession(session2, session2.getTransaction());
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                this.doScan(session2);
                session2.fireEvents(session2.getEvents(), null);
            } else {
                if (((ApplicationEx)app).holdsReadLock()) {
                    LOG.error("Do not call synchronous refresh under read lock (except from EDT) - this will cause a deadlock if there are any events to fire.");
                    return;
                }
                this.queueSession(session2, TransactionGuard.getInstance().getContextTransaction());
                session2.waitFor();
            }
        }
    }

    private void queueSession(@NotNull RefreshSessionImpl session2, @Nullable TransactionId transaction) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(1);
        }
        this.myQueue.execute(() -> {
            this.startRefreshActivity();
            try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Doing file refresh. " + (Object)((Object)session2));){
                this.doScan(session2);
            }
            finally {
                this.finishRefreshActivity();
                if (Registry.is((String)"vfs.async.event.processing")) {
                    this.scheduleAsynchronousPreprocessing(session2, transaction);
                } else {
                    TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), transaction, () -> session2.fireEvents(session2.getEvents(), null));
                }
            }
        });
        this.myEventCounter.eventHappened((Object)session2);
    }

    private void scheduleAsynchronousPreprocessing(@NotNull RefreshSessionImpl session2, @Nullable TransactionId transaction) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(2);
        }
        this.myEventProcessingQueue.submit(() -> {
            this.startRefreshActivity();
            try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Processing VFS events. " + (Object)((Object)session2));){
                this.processAndFireEvents(session2, transaction);
            }
            finally {
                this.finishRefreshActivity();
            }
        });
    }

    private synchronized void startRefreshActivity() {
        if (this.myBusyThreads++ == 0) {
            this.myRefreshIndicator.start();
        }
    }

    private synchronized void finishRefreshActivity() {
        if (--this.myBusyThreads == 0) {
            this.myRefreshIndicator.stop();
        }
    }

    private void processAndFireEvents(@NotNull RefreshSessionImpl session2, @Nullable TransactionId transaction) {
        boolean success;
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(3);
        }
        while (!(success = ProgressIndicatorUtils.runWithWriteActionPriority(() -> this.tryProcessingEvents(session2, transaction), new SensitiveProgressWrapper(this.myRefreshIndicator)))) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
    }

    private void tryProcessingEvents(@NotNull RefreshSessionImpl session2, @Nullable TransactionId transaction) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(4);
        }
        List events = ContainerUtil.filter(session2.getEvents(), e -> {
            VirtualFile file2 = e instanceof VFileCreateEvent ? ((VFileCreateEvent)e).getParent() : e.getFile();
            return file2 == null || file2.isValid();
        });
        List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
        long stamp = this.myWriteActionCounter.get();
        TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), transaction, () -> {
            if (stamp == this.myWriteActionCounter.get()) {
                session2.fireEvents(events, appliers);
            } else {
                this.scheduleAsynchronousPreprocessing(session2, transaction);
            }
        });
    }

    private void doScan(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(5);
        }
        try {
            this.updateSessionMap(session2, true);
            session2.scan();
        }
        finally {
            this.updateSessionMap(session2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(@NotNull RefreshSession session2, boolean add) {
        long id;
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(6);
        }
        if ((id = session2.getId()) != 0L) {
            TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
            synchronized (tLongObjectHashMap) {
                if (add) {
                    this.mySessions.put(id, (Object)session2);
                } else {
                    this.mySessions.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSession(long id) {
        RefreshSession session2;
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            session2 = (RefreshSession)this.mySessions.get(id);
        }
        if (session2 instanceof RefreshSessionImpl) {
            ((RefreshSessionImpl)session2).cancel();
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state) {
        if (state == null) {
            RefreshQueueImpl.$$$reportNull$$$0(7);
        }
        RefreshSessionImpl refreshSessionImpl = new RefreshSessionImpl(async, recursively, finishRunnable, state);
        if (refreshSessionImpl == null) {
            RefreshQueueImpl.$$$reportNull$$$0(8);
        }
        return refreshSessionImpl;
    }

    public void processSingleEvent(@NotNull VFileEvent event) {
        if (event == null) {
            RefreshQueueImpl.$$$reportNull$$$0(9);
        }
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = refreshQueue.mySessions;
        synchronized (tLongObjectHashMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            this.mySessions.forEachValue(session2 -> {
                ((RefreshSessionImpl)((Object)session2)).cancel();
                return true;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queueSession";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsynchronousPreprocessing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAndFireEvents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessingEvents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doScan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSessionMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSingleEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

