/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u001aF\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016\u001aP\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"nonAscii", "Lkotlin/text/Regex;", "systemSymbols", "copyEscaped", "", "", "", "from", "escape", "str", "escapeFieldName", "newLogEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "session", "build", "bucket", "time", "", "groupId", "groupVersion", "recorderVersion", "event", "Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "type", "isState", "", "intellij.platform.ide.impl"})
public final class LogEventsKt {
    private static final Regex nonAscii = new Regex("[^\\p{ASCII}]");
    private static final Regex systemSymbols = new Regex("[ \t:;,]");

    @NotNull
    public static final LogEvent newLogEvent(@NotNull String session2, @NotNull String build2, @NotNull String bucket, long time, @NotNull String groupId, @NotNull String groupVersion, @NotNull String recorderVersion, @NotNull LogEventAction event) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)groupVersion, (String)"groupVersion");
        Intrinsics.checkParameterIsNotNull((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return new LogEvent(session2, build2, bucket, time, groupId, groupVersion, recorderVersion, event);
    }

    @NotNull
    public static final LogEvent newLogEvent(@NotNull String session2, @NotNull String build2, @NotNull String bucket, long time, @NotNull String groupId, @NotNull String groupVersion, @NotNull String recorderVersion, @NotNull String type, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)groupVersion, (String)"groupVersion");
        Intrinsics.checkParameterIsNotNull((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        LogEventAction event = new LogEventAction(LogEventsKt.escape(type), isState, 1);
        return new LogEvent(session2, build2, bucket, time, groupId, groupVersion, recorderVersion, event);
    }

    public static /* synthetic */ LogEvent newLogEvent$default(String string, String string2, String string3, long l, String string4, String string5, String string6, String string7, boolean bl, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl = false;
        }
        return LogEventsKt.newLogEvent(string, string2, string3, l, string4, string5, string6, string7, bl);
    }

    @NotNull
    public static final String escape(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"'", (String)"", (boolean)false, (int)4, null), (String)"\"", (String)"", (boolean)false, (int)4, null);
        Regex regex = systemSymbols;
        String string = "_";
        boolean bl = false;
        charSequence = regex.replace(charSequence, string);
        regex = nonAscii;
        string = "?";
        bl = false;
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String escapeFieldName(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        return StringsKt.replace$default((String)LogEventsKt.escape(str), (char)'.', (char)'_', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Map<String, Object> copyEscaped(@NotNull Map<String, Object> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        if (from.isEmpty()) {
            Map<String, Object> map2 = Collections.emptyMap();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.emptyMap()");
            return map2;
        }
        Map data = new HashMap();
        Map<String, Object> map3 = from;
        boolean bl = false;
        for (Map.Entry<String, Object> datum : map3.entrySet()) {
            Object object;
            if (datum.getValue() instanceof String) {
                Object object2 = datum.getValue();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                object = LogEventsKt.escape((String)object2);
            } else {
                object = datum.getValue();
            }
            Object escapedValue = object;
            data.put(LogEventsKt.escapeFieldName(datum.getKey()), escapedValue);
        }
        return data;
    }
}

