/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList;
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private Runnable myAfterCompletion;
    private Computable<Boolean> myStopEnabled;
    private String myTitle;
    private String myHelpId;
    private boolean myActivateToolWindow;
    private ConsoleView myUserProvidedConsole;

    public RunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process2) {
        if (project == null) {
            RunContentExecutor.$$$reportNull$$$0(0);
        }
        if (process2 == null) {
            RunContentExecutor.$$$reportNull$$$0(1);
        }
        this.myFilterList = new ArrayList<Filter>();
        this.myTitle = "Output";
        this.myHelpId = null;
        this.myActivateToolWindow = true;
        this.myProject = project;
        this.myProcess = process2;
    }

    public RunContentExecutor withFilter(Filter filter) {
        this.myFilterList.add(filter);
        return this;
    }

    public RunContentExecutor withTitle(String title) {
        this.myTitle = title;
        return this;
    }

    public RunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public RunContentExecutor withStop(@NotNull Runnable stop2, @NotNull Computable<Boolean> stopEnabled) {
        if (stop2 == null) {
            RunContentExecutor.$$$reportNull$$$0(2);
        }
        if (stopEnabled == null) {
            RunContentExecutor.$$$reportNull$$$0(3);
        }
        this.myStopAction = stop2;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public RunContentExecutor withAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
        return this;
    }

    public RunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public RunContentExecutor withActivateToolWindow(boolean activateToolWindow) {
        this.myActivateToolWindow = activateToolWindow;
        return this;
    }

    private ConsoleView createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        JComponent consolePanel = RunContentExecutor.createConsolePanel(console, (ActionGroup)actions);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console, this.myProcess, consolePanel, this.myTitle);
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)descriptor2, (Disposable)console);
        actions.add((AnAction)new RerunAction(consolePanel));
        actions.add((AnAction)new StopAction());
        actions.add((AnAction)new CloseAction(executor, descriptor2, this.myProject));
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(executor, descriptor2);
        if (this.myActivateToolWindow) {
            this.activateToolWindow();
        }
        return console;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole();
        view.attachToProcess(this.myProcess);
        if (this.myAfterCompletion != null) {
            this.myProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(RunContentExecutor.this.myAfterCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/RunContentExecutor$1", "processTerminated"));
                }
            });
        }
        this.myProcess.startNotify();
    }

    public void activateToolWindow() {
        ApplicationManager.getApplication().invokeLater(() -> ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.RUN).activate(null));
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        panel2.add((Component)RunContentExecutor.createToolbar(actions), "West");
        return panel2;
    }

    private static JComponent createToolbar(ActionGroup actions) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RunContentExecutor", actions, false);
        return actionToolbar.getComponent();
    }

    public void dispose() {
    }

    @NotNull
    public RunContentExecutor withConsole(@Nullable ConsoleView console) {
        this.myUserProvidedConsole = console;
        RunContentExecutor runContentExecutor = this;
        if (runContentExecutor == null) {
            RunContentExecutor.$$$reportNull$$$0(4);
        }
        return runContentExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopEnabled";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/RunContentExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/RunContentExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withStop";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StopAction
    extends AnAction
    implements DumbAware {
        StopAction() {
            super("Stop", "Stop", AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myStopAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(RunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myStopEnabled != null && (Boolean)RunContentExecutor.this.myStopEnabled.compute() != false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/RunContentExecutor$StopAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent consolePanel) {
            super("Rerun", "Rerun", AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(RunContentExecutor.this.myRerunAction != null);
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/RunContentExecutor$RerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

