/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import org.jetbrains.annotations.NotNull;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super("Refresh", "Check for new commits and refresh Log if necessary", AllIcons.Actions.Refresh);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VisiblePackRefresher refresher;
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(0);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi ui2 = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui2 instanceof AbstractVcsLogUi && !(refresher = ((AbstractVcsLogUi)ui2).getRefresher()).isValid()) {
            String message = "Trying to refresh invalid log tab.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
            refresher.setValid(true, false);
        }
        logManager.getDataManager().refresh(VcsLogUtil.getVisibleRoots(ui2));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(1);
        }
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/RefreshLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

