/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DefaultPreservingExecutor {
    private static final Logger LOG = Logger.getInstance(DefaultPreservingExecutor.class);
    private final Project myProject;
    private final Collection<VirtualFile> myRootsToSave;
    private final String myOperationTitle;
    private final Runnable myOperation;
    private final VcsShelveChangesSaver mySaver;

    public DefaultPreservingExecutor(@NotNull Project project, @NotNull Collection<VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            DefaultPreservingExecutor.$$$reportNull$$$0(0);
        }
        if (rootsToSave == null) {
            DefaultPreservingExecutor.$$$reportNull$$$0(1);
        }
        if (operationTitle == null) {
            DefaultPreservingExecutor.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            DefaultPreservingExecutor.$$$reportNull$$$0(3);
        }
        if (operation == null) {
            DefaultPreservingExecutor.$$$reportNull$$$0(4);
        }
        this.mySaver = new VcsShelveChangesSaver(project, indicator, operationTitle);
        this.myProject = project;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myOperation = operation;
    }

    public void execute() {
        Runnable operation = () -> {
            LOG.debug("starting");
            Ref savedSuccessfully = Ref.create();
            ProgressManager.getInstance().executeNonCancelableSection(() -> savedSuccessfully.set((Object)this.save()));
            LOG.debug("save result: " + savedSuccessfully.get());
            if (((Boolean)savedSuccessfully.get()).booleanValue()) {
                try {
                    LOG.debug("running operation");
                    this.myOperation.run();
                    LOG.debug("operation completed.");
                }
                finally {
                    LOG.debug("loading");
                    ProgressManager.getInstance().executeNonCancelableSection(() -> this.mySaver.load());
                }
            }
            LOG.debug("finished.");
        };
        new VcsFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    private boolean save() {
        Ref result2 = Ref.create();
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                this.mySaver.save(this.myRootsToSave);
                result2.set((Object)true);
            }
            catch (VcsException e) {
                LOG.info("Couldn't save local changes", (Throwable)e);
                VcsNotifier.getInstance(this.myProject).notifyError("Couldn't save uncommitted changes.", String.format("Tried to save uncommitted changes in shelve before %s, but failed with an error.<br/>%s", this.myOperationTitle, StringUtil.join((String[])e.getMessages())));
                result2.set((Object)false);
            }
        });
        return (Boolean)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootsToSave";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "operationTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "operation";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/DefaultPreservingExecutor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

