/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ignore.IgnoredToExcludedSynchronizer;
import com.intellij.dvcs.ignore.VcsIgnoredHolderUpdateListener;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitConflictsHolder;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitModulesFileReader;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.repo.GitUntrackedFilesHolder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @Nullable
    private final GitRepositoryIgnoredFilesHolder myIgnoredRepositoryFilesHolder;
    @Nullable
    private final GitConflictsHolder myConflictsHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    private GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean light) {
        if (rootDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(0);
        }
        if (gitDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(3);
        }
        super(project, rootDir, parentDisposable);
        this.myVcs = GitVcs.getInstance(project);
        this.myGitDir = gitDir;
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        this.myReader = new GitRepositoryReader(this.myRepositoryFiles);
        this.myInfo = this.readRepoInfo();
        if (!light) {
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this, this.myRepositoryFiles);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
            this.myIgnoredRepositoryFilesHolder = new GitRepositoryIgnoredFilesHolder(project, this, GitRepositoryManager.getInstance(project), Git.getInstance());
            Disposer.register((Disposable)this, (Disposable)this.myIgnoredRepositoryFilesHolder);
            this.myIgnoredRepositoryFilesHolder.addUpdateStateListener(new MyRepositoryIgnoredHolderUpdateListener(project));
            this.myIgnoredRepositoryFilesHolder.addUpdateStateListener((VcsIgnoredHolderUpdateListener)new IgnoredToExcludedSynchronizer(project, (Disposable)this));
            this.myConflictsHolder = new GitConflictsHolder(this);
            Disposer.register((Disposable)this, (Disposable)this.myConflictsHolder);
        } else {
            this.myUntrackedFilesHolder = null;
            this.myIgnoredRepositoryFilesHolder = null;
            this.myConflictsHolder = null;
        }
    }

    @Deprecated
    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(5);
        }
        GitRepository gitRepository = GitRepositoryImpl.getInstance(root, project, (Disposable)project, listenToRepoChanges);
        if (gitRepository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(6);
        }
        return gitRepository;
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(9);
        }
        GitRepository gitRepository = GitRepositoryImpl.getInstance(root, (VirtualFile)ObjectUtils.assertNotNull((Object)GitUtil.findGitDir(root)), project, parentDisposable, listenToRepoChanges);
        if (gitRepository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(10);
        }
        return gitRepository;
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        if (root == null) {
            GitRepositoryImpl.$$$reportNull$$$0(11);
        }
        if (gitDir == null) {
            GitRepositoryImpl.$$$reportNull$$$0(12);
        }
        if (project == null) {
            GitRepositoryImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            GitRepositoryImpl.$$$reportNull$$$0(14);
        }
        GitRepositoryImpl repository = new GitRepositoryImpl(root, gitDir, project, parentDisposable, !listenToRepoChanges);
        if (listenToRepoChanges) {
            repository.getUntrackedFilesHolder().setupVfsListener(project);
            repository.getIgnoredFilesHolder().setupListeners();
            repository.setupUpdater();
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
        GitRepositoryImpl gitRepositoryImpl = repository;
        if (gitRepositoryImpl == null) {
            GitRepositoryImpl.$$$reportNull$$$0(15);
        }
        return gitRepositoryImpl;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this, this.myRepositoryFiles);
        Disposer.register((Disposable)this, (Disposable)updater);
        if (this.myIgnoredRepositoryFilesHolder != null) {
            this.myIgnoredRepositoryFilesHolder.startRescan();
        }
    }

    @Override
    @Deprecated
    @NotNull
    public VirtualFile getGitDir() {
        VirtualFile virtualFile = this.myGitDir;
        if (virtualFile == null) {
            GitRepositoryImpl.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        GitRepositoryFiles gitRepositoryFiles = this.myRepositoryFiles;
        if (gitRepositoryFiles == null) {
            GitRepositoryImpl.$$$reportNull$$$0(17);
        }
        return gitRepositoryFiles;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.myUntrackedFilesHolder;
        if (gitUntrackedFilesHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(18);
        }
        return gitUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitConflictsHolder getConflictsHolder() {
        if (this.myConflictsHolder == null) {
            throw new IllegalStateException("Using conflicts holder with light git repository instance " + this);
        }
        GitConflictsHolder gitConflictsHolder = this.myConflictsHolder;
        if (gitConflictsHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(19);
        }
        return gitConflictsHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        GitRepoInfo gitRepoInfo = this.myInfo;
        if (gitRepoInfo == null) {
            GitRepositoryImpl.$$$reportNull$$$0(20);
        }
        return gitRepoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            GitRepositoryImpl.$$$reportNull$$$0(21);
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            GitRepositoryImpl.$$$reportNull$$$0(22);
        }
        return gitVcs;
    }

    @Override
    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        Collection<GitSubmoduleInfo> collection = this.myInfo.getSubmodules();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        GitBranchesCollection gitBranchesCollection = new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes());
        if (gitBranchesCollection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(24);
        }
        return gitBranchesCollection;
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        Collection<GitRemote> collection = this.myInfo.getRemotes();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Collection<GitBranchTrackInfo> collection = this.myInfo.getBranchTrackInfos();
        if (collection == null) {
            GitRepositoryImpl.$$$reportNull$$$0(26);
        }
        return collection;
    }

    @Override
    @Nullable
    public GitBranchTrackInfo getBranchTrackInfo(@NotNull String localBranchName) {
        if (localBranchName == null) {
            GitRepositoryImpl.$$$reportNull$$$0(27);
        }
        return (GitBranchTrackInfo)this.myInfo.getBranchTrackInfosMap().get((Object)localBranchName);
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public void update() {
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyIfRepoChanged(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        StopWatch sw = StopWatch.start((String)("Reading Git repo info in " + DvcsUtil.getShortRepositoryName((Repository)this)));
        File configFile = this.myRepositoryFiles.getConfigFile();
        GitConfig config = GitConfig.read(configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        boolean isShallow = this.myReader.hasShallowCommits();
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches().keySet(), state.getRemoteBranches().keySet());
        GitHooksInfo hooksInfo = this.myReader.readHooksInfo();
        Collection<GitSubmoduleInfo> submodules = new GitModulesFileReader().read(this.getSubmoduleFile());
        sw.report();
        GitRepoInfo gitRepoInfo = new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), new LinkedHashSet<GitRemote>(remotes), new HashMap<GitLocalBranch, Hash>(state.getLocalBranches()), new HashMap<GitRemoteBranch, Hash>(state.getRemoteBranches()), new LinkedHashSet<GitBranchTrackInfo>(trackInfos), submodules, hooksInfo, isShallow);
        if (gitRepoInfo == null) {
            GitRepositoryImpl.$$$reportNull$$$0(28);
        }
        return gitRepoInfo;
    }

    @NotNull
    private File getSubmoduleFile() {
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot()), ".gitmodules");
        if (file == null) {
            GitRepositoryImpl.$$$reportNull$$$0(29);
        }
        return file;
    }

    private static void notifyIfRepoChanged(@NotNull GitRepository repository, @NotNull GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        if (repository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(30);
        }
        if (previousInfo == null) {
            GitRepositoryImpl.$$$reportNull$$$0(31);
        }
        if (info == null) {
            GitRepositoryImpl.$$$reportNull$$$0(32);
        }
        if (!repository.getProject().isDisposed() && !info.equals(previousInfo)) {
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
    }

    private static void notifyListenersAsync(@NotNull GitRepository repository) {
        if (repository == null) {
            GitRepositoryImpl.$$$reportNull$$$0(33);
        }
        Runnable task = () -> ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), (Topic)GIT_REPO_CHANGE)).repositoryChanged(repository);
        BackgroundTaskUtil.executeOnPooledThread((Disposable)repository, (Runnable)task);
    }

    @NotNull
    public String toLogString() {
        String string = "GitRepository " + this.getRoot() + " : " + this.myInfo;
        if (string == null) {
            GitRepositoryImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        if (this.myIgnoredRepositoryFilesHolder == null) {
            throw new UnsupportedOperationException("Unsupported for light Git repository");
        }
        GitRepositoryIgnoredFilesHolder gitRepositoryIgnoredFilesHolder = this.myIgnoredRepositoryFilesHolder;
        if (gitRepositoryIgnoredFilesHolder == null) {
            GitRepositoryImpl.$$$reportNull$$$0(35);
        }
        return gitRepositoryIgnoredFilesHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDir";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryImpl";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousInfo";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryImpl";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilesHolder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictsHolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodules";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchTrackInfos";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "readRepoInfo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmoduleFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toLogString";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBranchTrackInfo";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfRepoChanged";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRepositoryIgnoredHolderUpdateListener
    implements VcsIgnoredHolderUpdateListener {
        @NotNull
        private final ChangesViewI myChangesViewI;
        @NotNull
        private final Project myProject;

        MyRepositoryIgnoredHolderUpdateListener(@NotNull Project project) {
            if (project == null) {
                MyRepositoryIgnoredHolderUpdateListener.$$$reportNull$$$0(0);
            }
            this.myChangesViewI = ChangesViewManager.getInstance((Project)project);
            this.myProject = project;
        }

        public void updateStarted() {
            this.myChangesViewI.scheduleRefresh();
        }

        public void updateFinished(@NotNull Collection<FilePath> ignoredPaths) {
            if (ignoredPaths == null) {
                MyRepositoryIgnoredHolderUpdateListener.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myChangesViewI.scheduleRefresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredPaths";
                    break;
                }
            }
            objectArray2[1] = "git4idea/repo/GitRepositoryImpl$MyRepositoryIgnoredHolderUpdateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

