/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import org.jetbrains.annotations.Nullable;

public class ExpressionParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#ru.yole.pythonlanguage.parsing.ExpressionParsing");
    public static final WhitespacesAndCommentsBinder CONSUME_COMMENTS_AND_SPACES_TO_LEFT = (tokens, atStreamEdge, getter) -> tokens.size();
    private static final TokenSet BRACKET_OR_COMMA = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COMMA});
    private static final TokenSet BRACKET_COLON_COMMA = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COLON, PyTokenTypes.COMMA});

    public ExpressionParsing(ParsingContext context) {
        super(context);
    }

    public boolean parsePrimaryExpression(boolean isTargetExpression) {
        IElementType firstToken = this.myBuilder.getTokenType();
        if (ExpressionParsing.isIdentifier(this.myBuilder)) {
            if (isTargetExpression) {
                ExpressionParsing.buildTokenElement(PyStubElementTypes.TARGET_EXPRESSION, this.myBuilder);
            } else {
                ExpressionParsing.buildTokenElement(this.getReferenceType(), this.myBuilder);
            }
            return true;
        }
        if (firstToken == PyTokenTypes.INTEGER_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.INTEGER_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.FLOAT_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.FLOAT_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.IMAGINARY_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.IMAGINARY_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.NONE_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.NONE_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.TRUE_KEYWORD || firstToken == PyTokenTypes.FALSE_KEYWORD || firstToken == PyTokenTypes.DEBUG_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.BOOL_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (PyTokenTypes.STRING_NODES.contains(firstToken) || firstToken == PyTokenTypes.FSTRING_START) {
            return this.parseStringLiteralExpression();
        }
        if (firstToken == PyTokenTypes.LPAR) {
            this.parseParenthesizedExpression(isTargetExpression);
            return true;
        }
        if (firstToken == PyTokenTypes.LBRACKET) {
            this.parseListLiteralExpression(this.myBuilder, isTargetExpression);
            return true;
        }
        if (firstToken == PyTokenTypes.LBRACE) {
            this.parseDictOrSetDisplay();
            return true;
        }
        if (firstToken == PyTokenTypes.TICK) {
            this.parseReprExpression(this.myBuilder);
            return true;
        }
        return this.parseEllipsis();
    }

    public boolean parseStringLiteralExpression() {
        PsiBuilder builder = this.myContext.getBuilder();
        IElementType tokenType = builder.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(tokenType) || tokenType == PyTokenTypes.FSTRING_START) {
            PsiBuilder.Marker marker = builder.mark();
            while (true) {
                if (PyTokenTypes.STRING_NODES.contains(tokenType = builder.getTokenType())) {
                    this.nextToken();
                    continue;
                }
                if (tokenType != PyTokenTypes.FSTRING_START) break;
                this.parseFormattedStringNode();
            }
            marker.done((IElementType)PyElementTypes.STRING_LITERAL_EXPRESSION);
            return true;
        }
        return false;
    }

    private void parseFormattedStringNode() {
        PsiBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_START)) {
            String prefixThenQuotes = builder.getTokenText();
            assert (prefixThenQuotes != null);
            String openingQuotes = prefixThenQuotes.replaceFirst("^[UuBbCcRrFf]*", "");
            PsiBuilder.Marker marker = builder.mark();
            this.nextToken();
            while (true) {
                if (this.atToken(PyTokenTypes.FSTRING_TEXT)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.parseFStringFragment();
            }
            if (this.atToken(PyTokenTypes.FSTRING_END)) {
                if (builder.getTokenText().equals(openingQuotes)) {
                    this.nextToken();
                } else {
                    builder.mark().error(openingQuotes + " expected");
                }
            } else if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                builder.mark().error(openingQuotes + " expected");
            } else {
                builder.error("unexpected f-string token");
            }
            marker.done((IElementType)PyElementTypes.FSTRING_NODE);
        }
    }

    private void parseFStringFragment() {
        PsiBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) {
            boolean recovery;
            PsiBuilder.Marker marker = builder.mark();
            this.nextToken();
            PsiBuilder.Marker recoveryMarker = builder.mark();
            boolean parsedExpression = this.myContext.getExpressionParser().parseExpressionOptional();
            if (parsedExpression) {
                recoveryMarker.drop();
                recoveryMarker = builder.mark();
            }
            boolean bl = recovery = !parsedExpression;
            while (!builder.eof() && !this.atAnyOfTokens(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION, PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START, PyTokenTypes.FSTRING_FRAGMENT_END, PyTokenTypes.FSTRING_END, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.EQ)) {
                this.nextToken();
                recovery = true;
            }
            if (recovery) {
                recoveryMarker.error(parsedExpression ? "unexpected expression part" : "expression expected");
                recoveryMarker.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            } else {
                recoveryMarker.drop();
            }
            this.matchToken(PyTokenTypes.EQ);
            boolean hasTypeConversion = this.matchToken(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION);
            boolean hasFormatPart = this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START);
            if (hasFormatPart) {
                this.parseFStringFragmentFormatPart();
            }
            String errorMessage = "} expected";
            if (!hasFormatPart && !this.atToken(PyTokenTypes.FSTRING_END)) {
                errorMessage = ": or " + errorMessage;
                if (!hasTypeConversion) {
                    errorMessage = "type conversion, " + errorMessage;
                }
            }
            this.checkMatches(PyTokenTypes.FSTRING_FRAGMENT_END, errorMessage);
            marker.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT);
        }
    }

    private void parseFStringFragmentFormatPart() {
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START)) {
            PsiBuilder.Marker marker = this.myContext.getBuilder().mark();
            this.nextToken();
            while (true) {
                if (this.atToken(PyTokenTypes.FSTRING_TEXT)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.parseFStringFragment();
            }
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT_FORMAT_PART);
        }
    }

    private void parseListLiteralExpression(PsiBuilder builder, boolean isTargetExpression) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.LBRACKET);
        PsiBuilder.Marker expr = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == PyTokenTypes.RBRACKET) {
            builder.advanceLexer();
            expr.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
            return;
        }
        if (!this.parseSingleExpression(isTargetExpression)) {
            builder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
        if (this.atForOrAsyncFor()) {
            this.parseComprehension(expr, PyTokenTypes.RBRACKET, PyElementTypes.LIST_COMP_EXPRESSION);
        } else {
            while (builder.getTokenType() != PyTokenTypes.RBRACKET) {
                if (!this.matchToken(PyTokenTypes.COMMA)) {
                    builder.error("expected ',' or ']'");
                }
                if (this.atToken(PyTokenTypes.RBRACKET)) break;
                if (this.parseSingleExpression(isTargetExpression)) continue;
                builder.error(PyBundle.message("PARSE.expected.expr.or.comma.or.bracket", new Object[0]));
                break;
            }
            this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
            expr.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
        }
    }

    private void parseComprehension(PsiBuilder.Marker expr, @Nullable IElementType endToken, IElementType exprType) {
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        do {
            this.myBuilder.advanceLexer();
            this.parseExpression(true, true);
            this.parseComprehensionRange(exprType == PyElementTypes.GENERATOR_EXPRESSION);
            while (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (this.parseOldExpression()) continue;
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } while (this.atForOrAsyncFor());
        if (endToken != null && !this.matchToken(endToken)) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.for.or.bracket", new Object[0]));
        }
        expr.done(exprType);
    }

    protected void parseComprehensionRange(boolean generatorExpression) {
        this.checkMatches(PyTokenTypes.IN_KEYWORD, "'in' expected");
        boolean result = generatorExpression ? this.parseORTestExpression(false, false) : this.parseTupleExpression(false, false, true);
        if (!result) {
            this.myBuilder.error("expression expected");
        }
    }

    private void parseDictOrSetDisplay() {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LBRACE);
        PsiBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.matchToken(PyTokenTypes.RBRACE)) {
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.EXP)) {
            if (!this.parseDoubleStarExpression(false)) {
                this.myBuilder.error("expression expected");
                expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
                return;
            }
            this.parseDictLiteralContentTail(expr);
            return;
        }
        PsiBuilder.Marker firstExprMarker = this.myBuilder.mark();
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
            firstExprMarker.drop();
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            this.parseDictLiteralTail(expr, firstExprMarker);
        } else if (this.atToken(PyTokenTypes.COMMA) || this.atToken(PyTokenTypes.RBRACE)) {
            firstExprMarker.drop();
            this.parseSetLiteralTail(expr);
        } else if (this.atForOrAsyncFor()) {
            firstExprMarker.drop();
            this.parseComprehension(expr, PyTokenTypes.RBRACE, PyElementTypes.SET_COMP_EXPRESSION);
        } else {
            this.myBuilder.error("expression expected");
            firstExprMarker.drop();
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
        }
    }

    private void parseDictLiteralTail(PsiBuilder.Marker startMarker, PsiBuilder.Marker firstKeyValueMarker) {
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
            firstKeyValueMarker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
            if (this.atToken(PyTokenTypes.RBRACE)) {
                this.myBuilder.advanceLexer();
            }
            startMarker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        firstKeyValueMarker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        if (this.atForOrAsyncFor()) {
            this.parseComprehension(startMarker, PyTokenTypes.RBRACE, PyElementTypes.DICT_COMP_EXPRESSION);
        } else {
            this.parseDictLiteralContentTail(startMarker);
        }
    }

    private void parseDictLiteralContentTail(PsiBuilder.Marker startMarker) {
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyBundle.message("PARSE.expected.comma", new Object[0]));
            if (!(this.atToken(PyTokenTypes.EXP) ? !this.parseDoubleStarExpression(false) : !this.parseKeyValueExpression())) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyBundle.message("PARSE.expected.rbrace", new Object[0]));
        startMarker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
    }

    private boolean parseKeyValueExpression() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseSingleExpression(false)) {
            marker.drop();
            return false;
        }
        this.checkMatches(PyTokenTypes.COLON, PyBundle.message("PARSE.expected.colon", new Object[0]));
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error("value expression expected");
            marker.drop();
            return false;
        }
        marker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        return true;
    }

    private void parseSetLiteralTail(PsiBuilder.Marker startMarker) {
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyBundle.message("PARSE.expected.comma", new Object[0]));
            if (this.parseSingleExpression(false)) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyBundle.message("PARSE.expected.rbrace", new Object[0]));
        startMarker.done((IElementType)PyElementTypes.SET_LITERAL_EXPRESSION);
    }

    private void parseParenthesizedExpression(boolean isTargetExpression) {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        PsiBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == PyTokenTypes.RPAR) {
            this.myBuilder.advanceLexer();
            expr.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            this.parseYieldOrTupleExpression(isTargetExpression);
            if (this.atForOrAsyncFor()) {
                this.parseComprehension(expr, PyTokenTypes.RPAR, PyElementTypes.GENERATOR_EXPRESSION);
            } else {
                PsiBuilder.Marker err = this.myBuilder.mark();
                boolean empty = true;
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.RPAR && this.myBuilder.getTokenType() != PyTokenTypes.LINE_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.FSTRING_END) {
                    this.myBuilder.advanceLexer();
                    empty = false;
                }
                if (!empty) {
                    err.error("Unexpected expression syntax");
                } else {
                    err.drop();
                }
                this.checkMatches(PyTokenTypes.RPAR, PyBundle.message("PARSE.expected.rpar", new Object[0]));
                expr.done((IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION);
            }
        }
    }

    private void parseReprExpression(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.TICK);
        PsiBuilder.Marker expr = builder.mark();
        builder.advanceLexer();
        this.parseExpression();
        this.checkMatches(PyTokenTypes.TICK, PyBundle.message("PARSE.expected.tick", new Object[0]));
        expr.done((IElementType)PyElementTypes.REPR_EXPRESSION);
    }

    public boolean parseMemberExpression(boolean isTargetExpression) {
        boolean recastFirstIdentifier = false;
        boolean recastQualifier = false;
        block0: do {
            boolean firstIdentifierIsTarget = isTargetExpression && !recastFirstIdentifier;
            PsiBuilder.Marker expr = this.myBuilder.mark();
            if (!this.parsePrimaryExpression(firstIdentifierIsTarget)) {
                expr.drop();
                return false;
            }
            while (true) {
                IElementType tokenType;
                if ((tokenType = this.myBuilder.getTokenType()) == PyTokenTypes.DOT) {
                    if (firstIdentifierIsTarget) {
                        recastFirstIdentifier = true;
                        expr.rollbackTo();
                        continue block0;
                    }
                    this.myBuilder.advanceLexer();
                    this.checkMatches(PyTokenTypes.IDENTIFIER, PyBundle.message("PARSE.expected.name", new Object[0]));
                    if (isTargetExpression && !recastQualifier && !this.atAnyOfTokens(PyTokenTypes.DOT, PyTokenTypes.LPAR, PyTokenTypes.LBRACKET)) {
                        expr.done(PyStubElementTypes.TARGET_EXPRESSION);
                    } else {
                        expr.done(this.getReferenceType());
                    }
                    expr = expr.precede();
                } else if (tokenType == PyTokenTypes.LPAR) {
                    this.parseArgumentList();
                    expr.done((IElementType)PyElementTypes.CALL_EXPRESSION);
                    expr = expr.precede();
                } else if (tokenType == PyTokenTypes.LBRACKET) {
                    this.myBuilder.advanceLexer();
                    PsiBuilder.Marker sliceOrTupleStart = this.myBuilder.mark();
                    PsiBuilder.Marker sliceItemStart = this.myBuilder.mark();
                    if (this.atToken(PyTokenTypes.COLON)) {
                        sliceOrTupleStart.drop();
                        PsiBuilder.Marker sliceMarker = this.myBuilder.mark();
                        sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
                        this.parseSliceEnd(expr, sliceItemStart);
                    } else {
                        boolean hadExpression = this.parseSingleExpression(false);
                        if (this.atToken(PyTokenTypes.COLON)) {
                            sliceOrTupleStart.drop();
                            this.parseSliceEnd(expr, sliceItemStart);
                        } else if (this.atToken(PyTokenTypes.COMMA)) {
                            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
                            if (!this.parseSliceListTail(expr, sliceOrTupleStart)) {
                                sliceOrTupleStart.rollbackTo();
                                if (!this.parseTupleExpression(false, false, false)) {
                                    this.myBuilder.error("tuple expression expected");
                                }
                                this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
                                expr.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
                            }
                        } else {
                            if (!hadExpression) {
                                this.myBuilder.error("expression expected");
                            }
                            sliceOrTupleStart.drop();
                            sliceItemStart.drop();
                            this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
                            expr.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
                        }
                    }
                    if (isTargetExpression && !recastQualifier) {
                        recastFirstIdentifier = true;
                        recastQualifier = true;
                        expr.rollbackTo();
                        continue block0;
                    }
                    expr = expr.precede();
                } else {
                    expr.drop();
                    continue block0;
                }
                recastFirstIdentifier = false;
            }
        } while (recastFirstIdentifier);
        return true;
    }

    private boolean parseEllipsis() {
        if (this.atToken(PyTokenTypes.DOT)) {
            PsiBuilder.Marker maybeEllipsis = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.matchToken(PyTokenTypes.DOT) && this.matchToken(PyTokenTypes.DOT)) {
                maybeEllipsis.done((IElementType)PyElementTypes.NONE_LITERAL_EXPRESSION);
                return true;
            }
            maybeEllipsis.rollbackTo();
        }
        return false;
    }

    public void parseSliceEnd(PsiBuilder.Marker exprStart, PsiBuilder.Marker sliceItemStart) {
        this.myBuilder.advanceLexer();
        if (this.atToken(PyTokenTypes.RBRACKET)) {
            PsiBuilder.Marker sliceMarker = this.myBuilder.mark();
            sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
            this.nextToken();
            exprStart.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            PsiBuilder.Marker sliceMarker = this.myBuilder.mark();
            sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        } else {
            this.parseSingleExpression(false);
        }
        if (!BRACKET_COLON_COMMA.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.colon.or.rbracket", new Object[0]));
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            this.parseSingleExpression(false);
        }
        sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
        if (!BRACKET_OR_COMMA.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error("']' or ',' expected");
        }
        this.parseSliceListTail(exprStart, null);
    }

    private boolean parseSliceListTail(PsiBuilder.Marker exprStart, @Nullable PsiBuilder.Marker sliceOrTupleStart) {
        boolean inSlice;
        boolean bl = inSlice = sliceOrTupleStart == null;
        while (this.atToken(PyTokenTypes.COMMA)) {
            this.nextToken();
            PsiBuilder.Marker sliceItemStart = this.myBuilder.mark();
            this.parseNamedTestExpression(false, false);
            if (this.matchToken(PyTokenTypes.COLON)) {
                inSlice = true;
                this.parseNamedTestExpression(false, false);
                if (this.matchToken(PyTokenTypes.COLON)) {
                    this.parseNamedTestExpression(false, false);
                }
            }
            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
            if (BRACKET_OR_COMMA.contains(this.myBuilder.getTokenType())) continue;
            this.myBuilder.error("']' or ',' expected");
            break;
        }
        this.checkMatches(PyTokenTypes.RBRACKET, PyBundle.message("PARSE.expected.rbracket", new Object[0]));
        if (inSlice) {
            if (sliceOrTupleStart != null) {
                sliceOrTupleStart.drop();
            }
            exprStart.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
        }
        return inSlice;
    }

    public void parseArgumentList() {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        PsiBuilder.Marker arglist = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        PsiBuilder.Marker genexpr = this.myBuilder.mark();
        int argNumber = 0;
        while (this.myBuilder.getTokenType() != PyTokenTypes.RPAR) {
            if (++argNumber > 1) {
                if (argNumber == 2 && this.atForOrAsyncFor() && genexpr != null) {
                    this.parseComprehension(genexpr, null, PyElementTypes.GENERATOR_EXPRESSION);
                    genexpr = null;
                    continue;
                }
                if (this.matchToken(PyTokenTypes.COMMA)) {
                    if (this.atToken(PyTokenTypes.RPAR)) {
                        break;
                    }
                } else {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.comma.or.rpar", new Object[0]));
                    break;
                }
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.MULT || this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
                PsiBuilder.Marker starArgMarker = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.parseSingleExpression(false)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                starArgMarker.done((IElementType)PyElementTypes.STAR_ARGUMENT_EXPRESSION);
                continue;
            }
            if (ExpressionParsing.isIdentifier(this.myBuilder)) {
                PsiBuilder.Marker keywordArgMarker = this.myBuilder.mark();
                ExpressionParsing.advanceIdentifierLike(this.myBuilder);
                if (this.myBuilder.getTokenType() == PyTokenTypes.EQ) {
                    this.myBuilder.advanceLexer();
                    if (!this.parseSingleExpression(false)) {
                        this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                    keywordArgMarker.done((IElementType)PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION);
                    continue;
                }
                keywordArgMarker.rollbackTo();
            }
            if (this.parseSingleExpression(false)) continue;
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            break;
        }
        if (genexpr != null) {
            genexpr.drop();
        }
        this.checkMatches(PyTokenTypes.RPAR, PyBundle.message("PARSE.expected.rpar", new Object[0]));
        arglist.done((IElementType)PyElementTypes.ARGUMENT_LIST);
    }

    public boolean parseExpressionOptional() {
        return this.parseTupleExpression(false, false, false);
    }

    public boolean parseExpressionOptional(boolean isTargetExpression) {
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    public void parseExpression() {
        if (!this.parseExpressionOptional()) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public void parseExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (!this.parseTupleExpression(stopOnIn, isTargetExpression, false)) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public boolean parseYieldOrTupleExpression(boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            PsiBuilder.Marker yieldExpr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                boolean parsed = this.parseTupleExpression(false, isTargetExpression, false);
                if (!parsed) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                yieldExpr.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
                return parsed;
            }
            this.parseTupleExpression(false, isTargetExpression, false);
            yieldExpr.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
            return true;
        }
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    protected boolean parseTupleExpression(boolean stopOnIn, boolean isTargetExpression, boolean oldTest) {
        boolean exprParseResult;
        PsiBuilder.Marker expr = this.myBuilder.mark();
        boolean bl = exprParseResult = oldTest ? this.parseOldTestExpression() : this.parseNamedTestExpression(stopOnIn, isTargetExpression);
        if (!exprParseResult) {
            expr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                PsiBuilder.Marker expr2 = this.myBuilder.mark();
                boolean bl2 = exprParseResult = oldTest ? this.parseOldTestExpression() : this.parseNamedTestExpression(stopOnIn, isTargetExpression);
                if (!exprParseResult) {
                    expr2.rollbackTo();
                    break;
                }
                expr2.drop();
            }
            expr.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseSingleExpression(boolean isTargetExpression) {
        return this.parseNamedTestExpression(false, isTargetExpression);
    }

    public boolean parseOldExpression() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(false);
        }
        return this.parseORTestExpression(false, false);
    }

    private boolean parseNamedTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (ExpressionParsing.isIdentifier(this.myBuilder) && this.myBuilder.lookAhead(1) == PyTokenTypes.COLONEQ) {
            ExpressionParsing.buildTokenElement(PyStubElementTypes.TARGET_EXPRESSION, this.myBuilder);
            this.myBuilder.advanceLexer();
            if (this.parseTestExpression(stopOnIn, isTargetExpression)) {
                expr.done((IElementType)PyElementTypes.ASSIGNMENT_EXPRESSION);
                return true;
            }
            expr.drop();
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            return false;
        }
        if (this.parseTestExpression(stopOnIn, isTargetExpression)) {
            if (!this.atToken(PyTokenTypes.COLONEQ)) {
                expr.drop();
                return true;
            }
            expr.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
            return false;
        }
        expr.drop();
        return false;
    }

    private boolean parseTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(false);
        }
        PsiBuilder.Marker condExpr = this.myBuilder.mark();
        if (!this.parseORTestExpression(stopOnIn, isTargetExpression)) {
            condExpr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
            PsiBuilder.Marker conditionMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseORTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            } else if (this.myBuilder.getTokenType() != PyTokenTypes.ELSE_KEYWORD) {
                if (this.atToken(PyTokenTypes.COLON)) {
                    conditionMarker.rollbackTo();
                    condExpr.drop();
                    return true;
                }
                this.myBuilder.error(PyBundle.message("PARSE.expected.else", new Object[0]));
            } else {
                this.myBuilder.advanceLexer();
                if (!this.parseNamedTestExpression(stopOnIn, isTargetExpression)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
            }
            conditionMarker.drop();
            condExpr.done((IElementType)PyElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            condExpr.drop();
        }
        return true;
    }

    private boolean parseOldTestExpression() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(true);
        }
        return this.parseORTestExpression(false, false);
    }

    private boolean parseLambdaExpression(boolean oldTest) {
        boolean parseExpressionResult;
        PsiBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getFunctionParser().parseParameterListContents(PyTokenTypes.COLON, false, true);
        boolean bl = parseExpressionResult = oldTest ? this.parseOldTestExpression() : this.parseSingleExpression(false);
        if (!parseExpressionResult) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
        }
        expr.done((IElementType)PyElementTypes.LAMBDA_EXPRESSION);
        return true;
    }

    protected boolean parseORTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseANDTestExpression(stopOnIn, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.OR_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.parseANDTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseANDTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.AND_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseNOTTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
            PsiBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parseComparisonExpression(stopOnIn, isTargetExpression);
    }

    private boolean parseComparisonExpression(boolean stopOnIn, boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseStarExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        if (stopOnIn && this.atToken(PyTokenTypes.IN_KEYWORD)) {
            expr.drop();
            return true;
        }
        while (PyTokenTypes.COMPARISON_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            if (this.atToken(PyTokenTypes.NOT_KEYWORD)) {
                PsiBuilder.Marker notMarker = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.atToken(PyTokenTypes.IN_KEYWORD)) {
                    notMarker.rollbackTo();
                    break;
                }
                notMarker.drop();
                this.myBuilder.advanceLexer();
            } else if (this.atToken(PyTokenTypes.IS_KEYWORD)) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
                    this.myBuilder.advanceLexer();
                }
            } else {
                this.myBuilder.advanceLexer();
            }
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseStarExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.MULT)) {
            PsiBuilder.Marker starExpr = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                starExpr.drop();
                return false;
            }
            starExpr.done((IElementType)PyElementTypes.STAR_EXPRESSION);
            return true;
        }
        return this.parseBitwiseORExpression(isTargetExpression);
    }

    private boolean parseDoubleStarExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.EXP)) {
            PsiBuilder.Marker starExpr = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                starExpr.drop();
                return false;
            }
            starExpr.done((IElementType)PyElementTypes.DOUBLE_STAR_EXPRESSION);
            return true;
        }
        return this.parseBitwiseORExpression(isTargetExpression);
    }

    private boolean parseBitwiseORExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseBitwiseXORExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.OR)) {
            this.myBuilder.advanceLexer();
            if (!this.parseBitwiseXORExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseBitwiseXORExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseBitwiseANDExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.XOR)) {
            this.myBuilder.advanceLexer();
            if (!this.parseBitwiseANDExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseBitwiseANDExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseShiftExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.AND)) {
            this.myBuilder.advanceLexer();
            if (!this.parseShiftExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseShiftExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseAdditiveExpression(this.myBuilder, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.SHIFT_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseAdditiveExpression(this.myBuilder, isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAdditiveExpression(PsiBuilder myBuilder, boolean isTargetExpression) {
        PsiBuilder.Marker expr = myBuilder.mark();
        if (!this.parseMultiplicativeExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.ADDITIVE_OPERATIONS.contains(myBuilder.getTokenType())) {
            myBuilder.advanceLexer();
            if (!this.parseMultiplicativeExpression(isTargetExpression)) {
                myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseMultiplicativeExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseUnaryExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseUnaryExpression(boolean isTargetExpression) {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (PyTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePowerExpression(isTargetExpression);
    }

    private boolean parsePowerExpression(boolean isTargetExpression) {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseAwaitExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    private boolean parseAwaitExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.AWAIT_KEYWORD)) {
            PsiBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseMemberExpression(isTargetExpression)) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            } else if (isTargetExpression) {
                expr.error("can't assign to await expression");
            } else {
                expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            }
            return true;
        }
        return this.parseMemberExpression(isTargetExpression);
    }

    private boolean atForOrAsyncFor() {
        if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
            return true;
        }
        if (this.matchToken(PyTokenTypes.ASYNC_KEYWORD)) {
            if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
                return true;
            }
            this.myBuilder.error("'for' expected");
            return false;
        }
        return false;
    }
}

