/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Maps;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class PythonDocumentationEntryEditor
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myNameField;
    private JTextField myURLPatternTextField;
    private JButton myInsertButton;
    private JBList myMacroList;

    public PythonDocumentationEntryEditor(Component parent) {
        super(parent, true);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Edit Documentation URL");
        this.myInsertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object text2 = PythonDocumentationEntryEditor.this.myMacroList.getSelectedValue();
                if (text2 != null) {
                    String macroName = text2.toString();
                    int pos = macroName.indexOf(" - ");
                    if (pos >= 0) {
                        macroName = macroName.substring(0, pos);
                    }
                    try {
                        PythonDocumentationEntryEditor.this.myURLPatternTextField.getDocument().insertString(PythonDocumentationEntryEditor.this.myURLPatternTextField.getCaretPosition(), macroName, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.myMacroList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PythonDocumentationEntryEditor.this.updateButtonEnabled();
            }
        });
        this.updateButtonEnabled();
    }

    private void updateButtonEnabled() {
        this.myInsertButton.setEnabled(this.myMacroList.getSelectedValue() != null);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public Map.Entry<String, String> getEntry() {
        return Maps.immutableEntry((Object)this.myNameField.getText(), (Object)this.myURLPatternTextField.getText());
    }

    public void setEntry(Map.Entry<String, String> entry) {
        this.myNameField.setText(entry.getKey());
        this.myURLPatternTextField.setText(entry.getValue());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBList jBList;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Module Name:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("URL/Path Pattern:");
        jLabel2.setDisplayedMnemonic('U');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURLPatternTextField = jTextField = new JTextField();
        jTextField.setColumns(50);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(600, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Available Macros", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 150), null));
        this.myMacroList = jBList = new JBList();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement("{element.name} - name of element under caret");
        defaultListModel.addElement("{element.qname} - full-qualified name of element under caret");
        defaultListModel.addElement("{module.name} - name of module containing element under caret");
        defaultListModel.addElement("{module.basename} - last component of the full-qualified module name of element under caret");
        defaultListModel.addElement("{class.name} - name of class containing element under caret");
        defaultListModel.addElement("{function.name} - name of function under caret");
        defaultListModel.addElement("{functionOrProp.name} - name of function or property (e.g. isEnabled reduced to enabled)");
        defaultListModel.addElement("{functionIsProperty?} - boolean macros that checks whether function is property,");
        defaultListModel.addElement("if true substitutes with text between ? and }");
        defaultListModel.addElement("{python.version} - version of selected Python interpreter");
        defaultListModel.addElement(".lower - convert text to lower case");
        defaultListModel.addElement(".slashes - replace . with /");
        defaultListModel.addElement(".dashes - replace _ with -");
        jBList.setModel(defaultListModel);
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myInsertButton = jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setText("Insert");
        jButton.setMnemonic('I');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

