/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class XDebuggerEvaluator {
    public abstract void evaluate(@NotNull String var1, @NotNull XEvaluationCallback var2, @Nullable XSourcePosition var3);

    public void evaluate(@NotNull XExpression expression, @NotNull XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        this.evaluate(expression.getExpression(), callback, expressionPosition);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return null;
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        TextRange range;
        if (project == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (document == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        return (range = this.getExpressionRangeAtOffset(project, document, offset, sideEffectsAllowed)) == null ? null : new ExpressionInfo(range);
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        if (document == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(5);
        }
        Promise promise = Promises.resolvedPromise((Object)this.getExpressionInfoAtOffset(project, document, offset, sideEffectsAllowed));
        if (promise == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        if (text == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(7);
        }
        String string = text;
        if (string == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(8);
        }
        return string;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text == null) {
            XDebuggerEvaluator.$$$reportNull$$$0(9);
        }
        return text.contains("\n") ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/evaluation/XDebuggerEvaluator";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/evaluation/XDebuggerEvaluator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTextForEvaluation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatTextForEvaluation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface XEvaluationCallback
    extends XValueCallback {
        public void evaluated(@NotNull XValue var1);
    }
}

