/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressPanelBuilder
implements GridBagPanelBuilder,
PanelBuilder {
    private static final Color SEPARATOR_COLOR = new JBColor((Color)Gray.xC9, (Color)Gray.x55);
    private final JProgressBar myProgressBar;
    private String initialLabelText;
    private boolean labelAbove = true;
    private Runnable cancelAction;
    private Runnable resumeAction;
    private Runnable pauseAction;
    private String cancelText = "Cancel";
    private boolean cancelAsButton;
    private boolean smallVariant;
    private boolean commentEnabled = true;
    private boolean topSeparatorEnabled;
    private boolean valid = true;

    public ProgressPanelBuilder(JProgressBar progressBar) {
        this.myProgressBar = progressBar;
    }

    public ProgressPanelBuilder withLabel(@NotNull String text) {
        if (text == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(0);
        }
        this.initialLabelText = text;
        return this;
    }

    public ProgressPanelBuilder moveLabelLeft() {
        this.labelAbove = false;
        return this;
    }

    public ProgressPanelBuilder withCancel(@NotNull Runnable cancelAction) {
        if (cancelAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(1);
        }
        this.cancelAction = cancelAction;
        this.valid = this.resumeAction == null && this.pauseAction == null;
        return this;
    }

    public ProgressPanelBuilder andCancelText(String cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ProgressPanelBuilder andCancelAsButton() {
        this.cancelAsButton = true;
        return this;
    }

    public ProgressPanelBuilder withResume(@NotNull Runnable playAction) {
        if (playAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(2);
        }
        this.resumeAction = playAction;
        this.valid = this.pauseAction != null && this.cancelAction == null;
        return this;
    }

    public ProgressPanelBuilder withPause(@NotNull Runnable pauseAction) {
        if (pauseAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(3);
        }
        this.pauseAction = pauseAction;
        this.valid = this.resumeAction != null && this.cancelAction == null;
        return this;
    }

    public ProgressPanelBuilder andSmallIcons() {
        this.smallVariant = true;
        return this;
    }

    public ProgressPanelBuilder withoutComment() {
        this.commentEnabled = false;
        return this;
    }

    public ProgressPanelBuilder withTopSeparator() {
        this.topSeparatorEnabled = true;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public void addToPanel(JPanel panel2, GridBagConstraints gc) {
        if (this.constrainsValid()) {
            new LabeledPanelImpl().addToPanel(panel2, gc);
        }
    }

    @Override
    public int gridWidth() {
        int width = this.labelAbove ? 1 : 2;
        return width += this.cancelAction != null || this.resumeAction != null && this.pauseAction != null ? 1 : 0;
    }

    static /* synthetic */ Color access$200() {
        return SEPARATOR_COLOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pauseAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withCancel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withResume";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withPause";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LabeledPanelImpl
    extends ProgressPanel {
        private final JLabel label;
        private final JLabel comment;
        private String myCommentText = this.emptyComment();
        private boolean myServiceComment = false;
        private InplaceButton button;
        private final IconButton cancelIcon;
        private final IconButton resumeIcon;
        private final IconButton pauseIcon;
        private final SeparatorComponent mySeparatorComponent = new SeparatorComponent(ProgressPanelBuilder.access$200(), SeparatorOrientation.HORIZONTAL);
        private ProgressPanel.State state = ProgressPanel.State.PLAYING;

        private LabeledPanelImpl() {
            this.label = new JLabel(StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText) ? ProgressPanelBuilder.this.initialLabelText : "");
            this.comment = new JLabel(this.myCommentText);
            this.comment.setForeground((Color)Gray.x78);
            if (SystemInfo.isMac) {
                Font font = this.comment.getFont();
                float size = font.getSize2D();
                Font smallFont = font.deriveFont(size - 2.0f);
                this.comment.setFont(smallFont);
            }
            if (StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
            }
            this.cancelIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered);
            this.resumeIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmall : AllIcons.Process.ProgressResume, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmallHover : AllIcons.Process.ProgressResumeHover);
            this.pauseIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmall : AllIcons.Process.ProgressPause, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmallHover : AllIcons.Process.ProgressPauseHover);
        }

        private String emptyComment() {
            return ProgressPanelBuilder.this.commentEnabled ? " " : "";
        }

        @Override
        public String getLabelText() {
            return this.label.getText();
        }

        @Override
        public void setLabelText(String labelText) {
            this.label.setText(StringUtil.isNotEmpty((String)labelText) ? labelText : "");
            if (StringUtil.isNotEmpty((String)labelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
            }
        }

        @Override
        public String getCommentText() {
            return this.myServiceComment ? this.myCommentText : this.comment.getText();
        }

        @Override
        public void setCommentText(String commentText) {
            if (ProgressPanelBuilder.this.commentEnabled) {
                this.setCommentText(commentText, false);
            }
        }

        @Override
        public void setSeparatorEnabled(boolean enabled) {
            this.mySeparatorComponent.setVisible(enabled);
        }

        private void setCommentText(String commentText, boolean serviceComment) {
            if (serviceComment) {
                this.myServiceComment = commentText != null;
                this.comment.setText(commentText == null ? this.myCommentText : commentText);
            } else if (!this.myServiceComment) {
                this.myCommentText = StringUtil.isNotEmpty((String)commentText) ? commentText : this.emptyComment();
                this.comment.setText(this.myCommentText);
            }
        }

        @Override
        public ProgressPanel.State getState() {
            return this.state;
        }

        private void addToPanel(JPanel panel2, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.anchor = 21;
            gc.fill = 2;
            if (ProgressPanelBuilder.this.topSeparatorEnabled) {
                gc.insets = JBUI.insets((int)14, (int)0, (int)10, (int)0);
                gc.gridwidth = ProgressPanelBuilder.this.gridWidth();
                gc.weightx = 1.0;
                panel2.add((Component)this.mySeparatorComponent, gc);
                ++gc.gridy;
            }
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 0 : 12), (int)13, (int)0, (int)(ProgressPanelBuilder.this.labelAbove ? 13 : 0));
            panel2.add((Component)this.label, gc);
            if (ProgressPanelBuilder.this.labelAbove) {
                gc.insets = JBUI.insets((int)4, (int)13, (int)4, (int)0);
                ++gc.gridy;
            } else {
                gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 2 : 14), (int)12, (int)0, (int)0);
                ++gc.gridx;
            }
            gc.weightx = 1.0;
            panel2.add((Component)ProgressPanelBuilder.this.myProgressBar, gc);
            ++gc.gridx;
            ProgressPanelBuilder.this.myProgressBar.putClientProperty("JComponent.decoratedPanel", this);
            gc.weightx = 0.0;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.labelAbove || ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 1 : 14), (int)(UIUtil.isUnderWin10LookAndFeel() ? 9 : 10), (int)0, (int)13);
            if (ProgressPanelBuilder.this.cancelAction != null) {
                if (ProgressPanelBuilder.this.cancelAsButton) {
                    JButton cancelButton = new JButton(ProgressPanelBuilder.this.cancelText);
                    cancelButton.addActionListener(e -> ProgressPanelBuilder.this.cancelAction.run());
                    panel2.add((Component)cancelButton, gc);
                } else {
                    this.button = new InplaceButton(this.cancelIcon, a -> {
                        this.button.setPainting(false);
                        this.state = ProgressPanel.State.CANCELLED;
                        ProgressPanelBuilder.this.cancelAction.run();
                    }).setFillBg(false);
                }
            } else if (ProgressPanelBuilder.this.resumeAction != null && ProgressPanelBuilder.this.pauseAction != null) {
                this.button = new InplaceButton(this.pauseIcon, a -> {
                    if (this.state == ProgressPanel.State.PLAYING) {
                        this.button.setIcons(this.resumeIcon);
                        this.state = ProgressPanel.State.PAUSED;
                        this.setCommentText("Paused", true);
                        ProgressPanelBuilder.this.pauseAction.run();
                    } else {
                        this.button.setIcons(this.pauseIcon);
                        this.state = ProgressPanel.State.PLAYING;
                        this.setCommentText("Pause", true);
                        ProgressPanelBuilder.this.resumeAction.run();
                    }
                }).setFillBg(false);
            }
            if (this.button != null) {
                this.button.setMinimumSize(this.button.getPreferredSize());
                if (ProgressPanelBuilder.this.commentEnabled) {
                    this.button.addMouseListener(new HoverListener());
                }
                gc.anchor = 13;
                gc.fill = 0;
                panel2.add((Component)this.button, gc);
            }
            if (ProgressPanelBuilder.this.commentEnabled) {
                ++gc.gridy;
                gc.gridx = ProgressPanelBuilder.this.labelAbove ? 0 : 1;
                gc.insets = ProgressPanelBuilder.this.labelAbove ? JBUI.insets((int)-1, (int)13, (int)0, (int)13) : JBUI.insets((int)-1, (int)12, (int)0, (int)13);
                gc.weightx = 1.0;
                gc.anchor = 21;
                gc.fill = 2;
                panel2.add((Component)this.comment, gc);
            }
            ++gc.gridy;
        }

        private class HoverListener
        extends MouseAdapter {
            private HoverListener() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ProgressPanelBuilder.this.cancelAction != null) {
                    LabeledPanelImpl.this.setCommentText(ProgressPanelBuilder.this.cancelText, true);
                } else if (ProgressPanelBuilder.this.resumeAction != null && ProgressPanelBuilder.this.pauseAction != null) {
                    LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state == ProgressPanel.State.PLAYING ? "Pause" : "Resume", true);
                } else {
                    LabeledPanelImpl.this.setCommentText(null, true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state != ProgressPanel.State.PAUSED ? null : "Paused", true);
            }
        }
    }
}

