/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.EnumUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.pdf.label.PdfLabelNumberingStyle;
import org.sejda.model.pdf.label.PdfPageLabel;

public class PdfPageLabelAdapter {
    private static final int LABEL_PREFIX_INDEX = 3;
    private static final int MIN_TOKENS = 3;
    private Integer pageNumber;
    private PdfPageLabel pdfPageLabel;

    public PdfPageLabelAdapter(String input) {
        try {
            this.doParseInput(input);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Could not parse input: '" + input + "'. " + e.getMessage(), e);
        }
    }

    private void doParseInput(String input) {
        String[] tokens = AdapterUtils.split(input);
        if (tokens.length < 3) {
            throw new ConversionException("Format expected is: pageNumber(mandatory):numberingStyle(mandatory):logicalPageNumber(mandatory):labelPrefix(optional)'");
        }
        this.pageNumber = AdapterUtils.parseInt(tokens[0], "page number");
        PdfLabelNumberingStyle numberingStyle = EnumUtils.valueOf(PdfLabelNumberingStyle.class, tokens[1], "numbering style");
        int labelSuffixStartFromNumber = AdapterUtils.parseInt(tokens[2], "label suffix start number");
        String labelPrefix = tokens.length < 4 ? "" : tokens[3];
        this.pdfPageLabel = StringUtils.isBlank((CharSequence)labelPrefix) ? PdfPageLabel.newInstanceWithoutLabel((PdfLabelNumberingStyle)numberingStyle, (int)labelSuffixStartFromNumber) : PdfPageLabel.newInstanceWithLabel((String)labelPrefix, (PdfLabelNumberingStyle)numberingStyle, (int)labelSuffixStartFromNumber);
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public PdfPageLabel getPdfPageLabel() {
        return this.pdfPageLabel;
    }
}

