/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.pdf.headerfooter.NumberingStyle;

public class TextStampPattern {
    private int currentPage;
    private int totalPages;
    private String batesSeq;
    private String fileSeq;
    private String filename;

    public TextStampPattern withPage(int currentPage, int totalPages) {
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        return this;
    }

    public TextStampPattern withBatesSequence(String batesSeq) {
        this.batesSeq = batesSeq;
        return this;
    }

    public TextStampPattern withFileSequence(String fileSeq) {
        this.fileSeq = fileSeq;
        return this;
    }

    public TextStampPattern withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public String build(String pattern) {
        String result = pattern;
        if (this.currentPage > 0) {
            result = StringUtils.replace((String)result, (String)"[PAGE_ROMAN]", (String)NumberingStyle.ROMAN.toStyledString(this.currentPage));
            result = StringUtils.replace((String)result, (String)"[PAGE_ARABIC]", (String)NumberingStyle.ARABIC.toStyledString(this.currentPage));
            result = StringUtils.replace((String)result, (String)"[PAGE_NUMBER]", (String)NumberingStyle.ARABIC.toStyledString(this.currentPage));
            result = StringUtils.replace((String)result, (String)"[TOTAL_PAGES_ROMAN]", (String)NumberingStyle.ROMAN.toStyledString(this.totalPages));
            result = StringUtils.replace((String)result, (String)"[TOTAL_PAGES_ARABIC]", (String)NumberingStyle.ARABIC.toStyledString(this.totalPages));
            result = StringUtils.replace((String)result, (String)"[TOTAL_PAGES]", (String)NumberingStyle.ARABIC.toStyledString(this.totalPages));
            result = StringUtils.replace((String)result, (String)"[PAGE_OF_TOTAL]", (String)String.format("%d of %d", this.currentPage, this.totalPages));
        }
        result = StringUtils.replace((String)result, (String)"[DATE]", (String)TextStampPattern.dateNow());
        if (this.filename != null) {
            result = StringUtils.replace((String)result, (String)"[BASE_NAME]", (String)FilenameUtils.getBaseName((String)this.filename));
        }
        if (this.batesSeq != null) {
            result = StringUtils.replace((String)result, (String)"[BATES_NUMBER]", (String)this.batesSeq);
        }
        if (this.fileSeq != null) {
            result = StringUtils.replace((String)result, (String)"[FILE_NUMBER]", (String)this.fileSeq);
        }
        return result;
    }

    public static String dateNow() {
        return new SimpleDateFormat("dd/MM/yyyy").format(new Date());
    }
}

