/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.io.File;
import java.util.List;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfFilesListLoadRequest;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.RemoveSelectedEvent;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.selection.ToolbarButton;
import org.pdfsam.ui.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveSelectedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveType;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;

class SelectionTableToolbar
extends ToolBar
implements ModuleOwned {
    private String ownerModule = "";

    public SelectionTableToolbar(String ownerModule, boolean canMove) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.getItems().addAll((Object[])new Node[]{new AddButton(ownerModule), new ClearButton(ownerModule), new RemoveButton(ownerModule)});
        if (canMove) {
            this.getItems().addAll((Object[])new Node[]{new MoveUpButton(ownerModule), new MoveDownButton(ownerModule)});
        }
        this.getStyleClass().add((Object)"selection-tool-bar");
    }

    public String getOwnerModule() {
        return this.ownerModule;
    }

    static class MoveDownButton
    extends BaseMoveSelectedButton {
        public MoveDownButton(String ownerModule) {
            super(ownerModule, MoveType.DOWN);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Moves down selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("Move _Down"));
        }
    }

    static class MoveUpButton
    extends BaseMoveSelectedButton {
        public MoveUpButton(String ownerModule) {
            super(ownerModule, MoveType.UP);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Moves up selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("Move _Up"));
        }
    }

    private static class BaseMoveSelectedButton
    extends ToolbarButton {
        private MoveType type;

        public BaseMoveSelectedButton(String ownerModule, MoveType type) {
            super(ownerModule);
            this.type = type;
            this.setDisable(true);
            this.setOnAction(this::moveOnClick);
            StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        }

        public void moveOnClick(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new MoveSelectedEvent(this.type), this.getOwnerModule());
        }

        @EventListener
        public void disableIfCannotMoveDown(SelectionChangedEvent event) {
            this.setDisable(!event.canMove(this.type));
        }
    }

    static class ClearButton
    extends SplitMenuButton
    implements ModuleOwned {
        private String ownerModule = "";

        public ClearButton(String ownerModule) {
            this.setId("clear-button");
            this.ownerModule = StringUtils.defaultString((String)ownerModule);
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "toolbar-splitbutton"});
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Removes every document")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Clear"));
            this.setOnAction(this::clear);
            MenuItem clearAllSettings = new MenuItem();
            clearAllSettings.setText(DefaultI18nContext.getInstance().i18n("C_lear all settings"));
            clearAllSettings.setOnAction(this::clearAll);
            this.getItems().add((Object)clearAllSettings);
        }

        public void clear(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearModuleEvent(), this.getOwnerModule());
        }

        public void clearAll(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearModuleEvent(true), this.getOwnerModule());
        }

        @EventStation
        public String getOwnerModule() {
            return this.ownerModule;
        }
    }

    static class RemoveButton
    extends ToolbarButton {
        public RemoveButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Removes selected documents")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Remove"));
            this.setOnAction(this::removeSelected);
            this.setDisable(true);
            StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        }

        public void removeSelected(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new RemoveSelectedEvent(), this.getOwnerModule());
        }

        @EventListener
        public void disableIfNoSelection(SelectionChangedEvent event) {
            this.setDisable(event.isClearSelection());
        }
    }

    static class AddButton
    extends SplitMenuButton
    implements ModuleOwned {
        private String ownerModule = "";

        public AddButton(String ownerModule) {
            this.ownerModule = StringUtils.defaultString((String)ownerModule);
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "toolbar-splitbutton"});
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Add documents to the table")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Add"));
            this.setOnAction(this::loadDocuments);
            MenuItem fromList = new MenuItem();
            fromList.setText(DefaultI18nContext.getInstance().i18n("PDF list from _text/csv file"));
            fromList.setOnAction(this::loadList);
            this.getItems().add((Object)fromList);
        }

        public void loadDocuments(ActionEvent event) {
            RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(DefaultI18nContext.getInstance().i18n("Select pdf documents to load"), FileType.PDF);
            List<File> chosenFiles = fileChooser.showOpenMultipleDialog(this.getScene().getWindow());
            if (chosenFiles != null && !chosenFiles.isEmpty()) {
                PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
                chosenFiles.stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
                StaticStudio.eventStudio().broadcast((Object)loadEvent, this.getOwnerModule());
            }
        }

        public void loadList(ActionEvent event) {
            RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(DefaultI18nContext.getInstance().i18n("Select a text or CSV file to load"), FileType.CSV, FileType.TXT);
            File chosenFile = fileChooser.showDialog(this.getScene().getWindow(), RememberingLatestFileChooserWrapper.OpenType.OPEN);
            if (Objects.nonNull(chosenFile)) {
                StaticStudio.eventStudio().broadcast((Object)new PdfFilesListLoadRequest(this.getOwnerModule(), chosenFile.toPath()));
            }
        }

        @EventStation
        public String getOwnerModule() {
            return this.ownerModule;
        }
    }
}

