/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.OsmandIndex;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class CachedOsmandIndexes {
    private OsmandIndex.OsmAndStoredIndex storedIndex;
    private OsmandIndex.OsmAndStoredIndex.Builder storedIndexBuilder;
    private Log log = PlatformUtil.getLog(CachedOsmandIndexes.class);
    private boolean hasChanged = true;
    public static final int VERSION = 2;

    public void addToCache(BinaryMapIndexReader reader, File f) {
        this.hasChanged = true;
        if (this.storedIndexBuilder == null) {
            this.storedIndexBuilder = OsmandIndex.OsmAndStoredIndex.newBuilder();
            this.storedIndexBuilder.setVersion(2);
            this.storedIndexBuilder.setDateCreated(System.currentTimeMillis());
            if (this.storedIndex != null) {
                for (OsmandIndex.FileIndex ex : this.storedIndex.getFileIndexList()) {
                    this.storedIndexBuilder.addFileIndex(ex);
                }
            }
        }
        OsmandIndex.FileIndex.Builder fileIndex = OsmandIndex.FileIndex.newBuilder();
        long d = reader.getDateCreated();
        fileIndex.setDateModified(d == 0L ? f.lastModified() : d);
        fileIndex.setSize(f.length());
        fileIndex.setVersion(reader.getVersion());
        fileIndex.setFileName(f.getName());
        for (BinaryMapIndexReader.MapIndex mapIndex : reader.getMapIndexes()) {
            OsmandIndex.MapPart.Builder map = OsmandIndex.MapPart.newBuilder();
            map.setSize(mapIndex.getLength());
            map.setOffset(mapIndex.getFilePointer());
            if (mapIndex.getName() != null) {
                map.setName(mapIndex.getName());
            }
            for (BinaryMapIndexReader.MapRoot mapRoot : mapIndex.getRoots()) {
                OsmandIndex.MapLevel.Builder lev = OsmandIndex.MapLevel.newBuilder();
                lev.setSize(mapRoot.length);
                lev.setOffset(mapRoot.filePointer);
                lev.setLeft(mapRoot.left);
                lev.setRight(mapRoot.right);
                lev.setTop(mapRoot.top);
                lev.setBottom(mapRoot.bottom);
                lev.setMinzoom(mapRoot.minZoom);
                lev.setMaxzoom(mapRoot.maxZoom);
                map.addLevels(lev);
            }
            fileIndex.addMapIndex(map);
        }
        for (BinaryMapAddressReaderAdapter.AddressRegion addressRegion : reader.getAddressIndexes()) {
            OsmandIndex.AddressPart.Builder addr = OsmandIndex.AddressPart.newBuilder();
            addr.setSize(addressRegion.getLength());
            addr.setOffset(addressRegion.getFilePointer());
            if (addressRegion.getName() != null) {
                addr.setName(addressRegion.getName());
            }
            if (addressRegion.getEnName() != null) {
                addr.setNameEn(addressRegion.getEnName());
            }
            addr.setIndexNameOffset(addressRegion.getIndexNameOffset());
            for (BinaryMapAddressReaderAdapter.CitiesBlock citiesBlock : addressRegion.getCities()) {
                OsmandIndex.CityBlock.Builder cblock = OsmandIndex.CityBlock.newBuilder();
                cblock.setSize(citiesBlock.length);
                cblock.setOffset(citiesBlock.filePointer);
                cblock.setType(citiesBlock.type);
                addr.addCities(cblock);
            }
            for (String string2 : addressRegion.getAttributeTagsTable()) {
                addr.addAdditionalTags(string2);
            }
            fileIndex.addAddressIndex(addr);
        }
        for (BinaryMapPoiReaderAdapter.PoiRegion poiRegion : reader.getPoiIndexes()) {
            OsmandIndex.PoiPart.Builder poi = OsmandIndex.PoiPart.newBuilder();
            poi.setSize(poiRegion.getLength());
            poi.setOffset(poiRegion.getFilePointer());
            if (poiRegion.getName() != null) {
                poi.setName(poiRegion.getName());
            }
            poi.setLeft(MapUtils.get31TileNumberX(poiRegion.getLeftLongitude()));
            poi.setRight(MapUtils.get31TileNumberX(poiRegion.getRightLongitude()));
            poi.setTop(MapUtils.get31TileNumberY(poiRegion.getTopLatitude()));
            poi.setBottom(MapUtils.get31TileNumberY(poiRegion.getBottomLatitude()));
            fileIndex.addPoiIndex(poi.build());
        }
        for (BinaryMapTransportReaderAdapter.TransportIndex transportIndex : reader.getTransportIndexes()) {
            OsmandIndex.TransportPart.Builder transport = OsmandIndex.TransportPart.newBuilder();
            transport.setSize(transportIndex.getLength());
            transport.setOffset(transportIndex.getFilePointer());
            if (transportIndex.getName() != null) {
                transport.setName(transportIndex.getName());
            }
            transport.setLeft(transportIndex.getLeft());
            transport.setRight(transportIndex.getRight());
            transport.setTop(transportIndex.getTop());
            transport.setBottom(transportIndex.getBottom());
            transport.setStopsTableLength(transportIndex.stopsFileLength);
            transport.setStopsTableOffset(transportIndex.stopsFileOffset);
            transport.setStringTableLength(transportIndex.stringTable.length);
            transport.setStringTableOffset(transportIndex.stringTable.fileOffset);
            fileIndex.addTransportIndex(transport);
        }
        for (BinaryMapRouteReaderAdapter.RouteRegion routeRegion : reader.getRoutingIndexes()) {
            OsmandIndex.RoutingPart.Builder routing = OsmandIndex.RoutingPart.newBuilder();
            routing.setSize(routeRegion.getLength());
            routing.setOffset(routeRegion.getFilePointer());
            if (routeRegion.getName() != null) {
                routing.setName(routeRegion.getName());
            }
            for (BinaryMapRouteReaderAdapter.RouteSubregion routeSubregion : routeRegion.getSubregions()) {
                this.addRouteSubregion(routing, routeSubregion, false);
            }
            for (BinaryMapRouteReaderAdapter.RouteSubregion routeSubregion : routeRegion.getBaseSubregions()) {
                this.addRouteSubregion(routing, routeSubregion, true);
            }
            fileIndex.addRoutingIndex(routing);
        }
        this.storedIndexBuilder.addFileIndex(fileIndex);
    }

    private void addRouteSubregion(OsmandIndex.RoutingPart.Builder routing, BinaryMapRouteReaderAdapter.RouteSubregion sub, boolean base) {
        OsmandIndex.RoutingSubregion.Builder rpart = OsmandIndex.RoutingSubregion.newBuilder();
        rpart.setSize(sub.length);
        rpart.setOffset(sub.filePointer);
        rpart.setLeft(sub.left);
        rpart.setRight(sub.right);
        rpart.setTop(sub.top);
        rpart.setBasemap(base);
        rpart.setBottom(sub.bottom);
        rpart.setShifToData(sub.shiftToData);
        routing.addSubregions(rpart);
    }

    public BinaryMapIndexReader getReader(File f) throws IOException {
        RandomAccessFile mf = new RandomAccessFile(f.getPath(), "r");
        OsmandIndex.FileIndex found = null;
        if (this.storedIndex != null) {
            for (int i = 0; i < this.storedIndex.getFileIndexCount(); ++i) {
                OsmandIndex.FileIndex fi = this.storedIndex.getFileIndex(i);
                if (f.length() != fi.getSize() || !f.getName().equals(fi.getFileName())) continue;
                found = fi;
                break;
            }
        }
        BinaryMapIndexReader reader = null;
        if (found == null) {
            long val = System.currentTimeMillis();
            reader = new BinaryMapIndexReader(mf, f);
            this.addToCache(reader, f);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initializing db " + f.getAbsolutePath() + " " + (System.currentTimeMillis() - val) + "ms"));
            }
        } else {
            reader = this.initFileIndex(found, mf, f);
        }
        return reader;
    }

    private BinaryMapIndexReader initFileIndex(OsmandIndex.FileIndex found, RandomAccessFile mf, File f) throws IOException {
        BinaryIndexPart mi;
        BinaryMapIndexReader reader = new BinaryMapIndexReader(mf, f, false);
        reader.version = found.getVersion();
        reader.dateCreated = found.getDateModified();
        for (OsmandIndex.MapPart mapPart : found.getMapIndexList()) {
            mi = new BinaryMapIndexReader.MapIndex();
            ((BinaryMapIndexReader.MapIndex)mi).length = (int)mapPart.getSize();
            ((BinaryMapIndexReader.MapIndex)mi).filePointer = (int)mapPart.getOffset();
            ((BinaryMapIndexReader.MapIndex)mi).name = mapPart.getName();
            for (OsmandIndex.MapLevel mapLevel : mapPart.getLevelsList()) {
                BinaryMapIndexReader.MapRoot root = new BinaryMapIndexReader.MapRoot();
                root.length = (int)mapLevel.getSize();
                root.filePointer = (int)mapLevel.getOffset();
                root.left = mapLevel.getLeft();
                root.right = mapLevel.getRight();
                root.top = mapLevel.getTop();
                root.bottom = mapLevel.getBottom();
                root.minZoom = mapLevel.getMinzoom();
                root.maxZoom = mapLevel.getMaxzoom();
                ((BinaryMapIndexReader.MapIndex)mi).roots.add(root);
            }
            reader.mapIndexes.add((BinaryMapIndexReader.MapIndex)mi);
            reader.indexes.add(mi);
            reader.basemap = reader.basemap || ((BinaryMapIndexReader.MapIndex)mi).isBaseMap();
        }
        for (OsmandIndex.AddressPart addressPart : found.getAddressIndexList()) {
            mi = new BinaryMapAddressReaderAdapter.AddressRegion();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).length = (int)addressPart.getSize();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).filePointer = (int)addressPart.getOffset();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).name = addressPart.getName();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).enName = addressPart.getNameEn();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).indexNameOffset = addressPart.getIndexNameOffset();
            for (OsmandIndex.CityBlock cityBlock : addressPart.getCitiesList()) {
                BinaryMapAddressReaderAdapter.CitiesBlock cblock = new BinaryMapAddressReaderAdapter.CitiesBlock();
                cblock.length = (int)cityBlock.getSize();
                cblock.filePointer = (int)cityBlock.getOffset();
                cblock.type = cityBlock.getType();
                ((BinaryMapAddressReaderAdapter.AddressRegion)mi).cities.add(cblock);
            }
            for (String string2 : addressPart.getAdditionalTagsList()) {
                ((BinaryMapAddressReaderAdapter.AddressRegion)mi).attributeTagsTable.add(string2);
            }
            reader.addressIndexes.add((BinaryMapAddressReaderAdapter.AddressRegion)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.PoiPart poiPart : found.getPoiIndexList()) {
            mi = new BinaryMapPoiReaderAdapter.PoiRegion();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).length = (int)poiPart.getSize();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).filePointer = (int)poiPart.getOffset();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).name = poiPart.getName();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).leftLongitude = MapUtils.get31LongitudeX(poiPart.getLeft());
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).rightLongitude = MapUtils.get31LongitudeX(poiPart.getRight());
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).topLatitude = MapUtils.get31LatitudeY(poiPart.getTop());
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).bottomLatitude = MapUtils.get31LatitudeY(poiPart.getBottom());
            reader.poiIndexes.add((BinaryMapPoiReaderAdapter.PoiRegion)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.TransportPart transportPart : found.getTransportIndexList()) {
            mi = new BinaryMapTransportReaderAdapter.TransportIndex();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).length = (int)transportPart.getSize();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).filePointer = (int)transportPart.getOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).name = transportPart.getName();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).left = transportPart.getLeft();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).right = transportPart.getRight();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).top = transportPart.getTop();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).bottom = transportPart.getBottom();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stopsFileLength = transportPart.getStopsTableLength();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stopsFileOffset = transportPart.getStopsTableOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable = new BinaryMapTransportReaderAdapter.IndexStringTable();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable.fileOffset = transportPart.getStringTableOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable.length = transportPart.getStringTableLength();
            reader.transportIndexes.add((BinaryMapTransportReaderAdapter.TransportIndex)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.RoutingPart routingPart : found.getRoutingIndexList()) {
            mi = new BinaryMapRouteReaderAdapter.RouteRegion();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).length = (int)routingPart.getSize();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).filePointer = (int)routingPart.getOffset();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).name = routingPart.getName();
            for (OsmandIndex.RoutingSubregion routingSubregion : routingPart.getSubregionsList()) {
                BinaryMapRouteReaderAdapter.RouteSubregion sub = new BinaryMapRouteReaderAdapter.RouteSubregion((BinaryMapRouteReaderAdapter.RouteRegion)mi);
                sub.length = (int)routingSubregion.getSize();
                sub.filePointer = (int)routingSubregion.getOffset();
                sub.left = routingSubregion.getLeft();
                sub.right = routingSubregion.getRight();
                sub.top = routingSubregion.getTop();
                sub.bottom = routingSubregion.getBottom();
                sub.shiftToData = routingSubregion.getShifToData();
                if (routingSubregion.getBasemap()) {
                    ((BinaryMapRouteReaderAdapter.RouteRegion)mi).basesubregions.add(sub);
                    continue;
                }
                ((BinaryMapRouteReaderAdapter.RouteRegion)mi).subregions.add(sub);
            }
            reader.routingIndexes.add((BinaryMapRouteReaderAdapter.RouteRegion)mi);
            reader.indexes.add(mi);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(File f, int version) throws IOException {
        long time = System.currentTimeMillis();
        try (FileInputStream is = new FileInputStream(f);){
            this.storedIndex = ((OsmandIndex.OsmAndStoredIndex.Builder)OsmandIndex.OsmAndStoredIndex.newBuilder().mergeFrom(is)).build();
            this.hasChanged = false;
            if (this.storedIndex.getVersion() != version) {
                this.storedIndex = null;
            }
        }
        this.log.info((Object)("Initialize cache " + (System.currentTimeMillis() - time)));
    }

    public void writeToFile(File f) throws IOException {
        if (this.hasChanged) {
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                this.storedIndexBuilder.build().writeTo(outputStream);
            }
        }
    }
}

