/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticsElementsCache {
    private final Diagnostics diagnostics;
    private final Function1<Diagnostic, Boolean> filter;
    private final AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>> elementToDiagnostic = new AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>>(){

        @Override
        @NotNull
        protected MultiMap<PsiElement, Diagnostic> compute() {
            MultiMap multiMap = DiagnosticsElementsCache.buildElementToDiagnosticCache(DiagnosticsElementsCache.this.diagnostics, DiagnosticsElementsCache.this.filter);
            if (multiMap == null) {
                1.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache$1", "compute"));
        }
    };

    public DiagnosticsElementsCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        this.diagnostics = diagnostics2;
        this.filter = filter2;
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DiagnosticsElementsCache.$$$reportNull$$$0(0);
        }
        Collection<Diagnostic> collection = this.elementToDiagnostic.getValue().get(psiElement);
        if (collection == null) {
            DiagnosticsElementsCache.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static MultiMap<PsiElement, Diagnostic> buildElementToDiagnosticCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        ConcurrentMultiMap<PsiElement, Diagnostic> elementToDiagnostic = new ConcurrentMultiMap<PsiElement, Diagnostic>();
        for (Diagnostic diagnostic : diagnostics2) {
            if (diagnostic == null) {
                throw new IllegalStateException("There shouldn't be null diagnostics in the collection: " + CollectionsKt.toList(diagnostics2));
            }
            if (!filter2.invoke(diagnostic).booleanValue()) continue;
            ((MultiMap)elementToDiagnostic).putValue(diagnostic.getPsiElement(), diagnostic);
        }
        return elementToDiagnostic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnostics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

