/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.ComponentList;
import net.sf.juife.ComponentListModel;
import net.sf.juife.DefaultComponentListModel;
import org.jsampler.CC;
import org.jsampler.SamplerChannelModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.Channel;
import org.jsampler.view.classic.ClassicI18n;

public class ChannelsPane
extends JSChannelsPane
implements ListSelectionListener {
    private final ComponentList chnList = new ComponentList();
    private final DefaultComponentListModel listModel = new DefaultComponentListModel();
    private final JScrollPane scrollPane;

    public ChannelsPane(String string) {
        super(string);
        this.setLayout(new BorderLayout());
        this.chnList.setOpaque(false);
        this.chnList.setModel(this.listModel);
        this.chnList.setSelectionMode(2);
        this.chnList.addListSelectionListener(this);
        this.chnList.addMouseListener(new ContextMenu());
        this.scrollPane = new JScrollPane(this.chnList);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.scrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    @Override
    public void setSelectedChannel(JSChannel jSChannel) {
        this.chnList.setSelectedComponent(jSChannel, true);
    }

    @Override
    public void addChannel(SamplerChannelModel samplerChannelModel) {
        Channel channel = new Channel(samplerChannelModel);
        this.listModel.add(channel);
        if (channel.getChannelInfo().getEngine() == null) {
            channel.expandChannel();
        }
        this.chnList.setSelectedComponent(channel, true);
        this.scrollToBottom();
    }

    @Override
    public void addChannels(JSChannel[] jSChannelArray) {
        if (jSChannelArray == null || jSChannelArray.length == 0) {
            return;
        }
        for (JSChannel jSChannel : jSChannelArray) {
            this.listModel.add(jSChannel);
        }
        this.chnList.setSelectionInterval(this.listModel.getSize() - jSChannelArray.length, this.listModel.getSize() - 1);
        this.chnList.ensureIndexIsVisible(this.listModel.getSize() - 1);
    }

    @Override
    public void removeChannel(JSChannel jSChannel) {
        this.listModel.remove(jSChannel);
    }

    @Override
    public JSChannel getFirstChannel() {
        return this.listModel.size() == 0 ? null : (JSChannel)this.listModel.get(0);
    }

    @Override
    public JSChannel getLastChannel() {
        return this.listModel.size() == 0 ? null : (JSChannel)this.listModel.get(this.listModel.size() - 1);
    }

    @Override
    public JSChannel getChannel(int n) {
        return (JSChannel)this.listModel.get(n);
    }

    @Override
    public JSChannel[] getChannels() {
        JSChannel[] jSChannelArray = new JSChannel[this.listModel.size()];
        for (int i = 0; i < this.listModel.size(); ++i) {
            jSChannelArray[i] = (JSChannel)this.listModel.get(i);
        }
        return jSChannelArray;
    }

    @Override
    public int getChannelCount() {
        return this.listModel.size();
    }

    @Override
    public boolean hasSelectedChannel() {
        return !this.chnList.isSelectionEmpty();
    }

    @Override
    public int getSelectedChannelCount() {
        return this.chnList.getSelectedIndices().length;
    }

    @Override
    public JSChannel[] getSelectedChannels() {
        Component[] componentArray = this.chnList.getSelectedComponents();
        JSChannel[] jSChannelArray = new JSChannel[componentArray.length];
        for (int i = 0; i < componentArray.length; ++i) {
            jSChannelArray[i] = (JSChannel)componentArray[i];
        }
        return jSChannelArray;
    }

    @Override
    public int removeSelectedChannels() {
        int n;
        int[] nArray = this.chnList.getSelectedIndices();
        ComponentListModel componentListModel = this.chnList.getModel();
        while ((n = this.chnList.getMinSelectionIndex()) != -1) {
            componentListModel.remove(n);
        }
        return nArray.length;
    }

    @Override
    public void selectAll() {
        this.chnList.selectAll();
    }

    @Override
    public void clearSelection() {
        this.chnList.clearSelection();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionEvent listSelectionEvent2 = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListSelectionListener.class) continue;
            if (listSelectionEvent2 == null) {
                listSelectionEvent2 = new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent2);
        }
    }

    @Override
    public boolean getAutoUpdate() {
        return this.chnList.getAutoUpdate();
    }

    @Override
    public void setAutoUpdate(boolean bl) {
        this.chnList.setAutoUpdate(bl);
    }

    @Override
    public void updateChannelListUI() {
        this.chnList.updateList();
    }

    @Override
    public void moveSelectedChannelsOnTop() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0) {
            CC.getLogger().info("Can't move channel(s) at the beginning");
            return;
        }
        for (int i = jSChannelArray.length - 1; i >= 0; --i) {
            this.listModel.remove(jSChannelArray[i]);
            this.listModel.insert(jSChannelArray[i], 0);
        }
        this.chnList.setSelectionInterval(0, jSChannelArray.length - 1);
        this.chnList.ensureIndexIsVisible(0);
    }

    @Override
    public void moveSelectedChannelsUp() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0 || jSChannelArray[0] == this.getFirstChannel()) {
            CC.getLogger().info("Can't move channel(s) up");
            return;
        }
        for (int i = 0; i < jSChannelArray.length; ++i) {
            this.listModel.moveUp(jSChannelArray[i]);
        }
        int[] nArray = this.chnList.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        this.chnList.setSelectedIndices(nArray);
        this.chnList.ensureIndexIsVisible(nArray[0]);
    }

    @Override
    public void moveSelectedChannelsDown() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0 || jSChannelArray[jSChannelArray.length - 1] == this.getLastChannel()) {
            CC.getLogger().info("Can't move channel(s) down");
            return;
        }
        for (int i = jSChannelArray.length - 1; i >= 0; --i) {
            this.listModel.moveDown(jSChannelArray[i]);
        }
        int[] nArray = this.chnList.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        this.chnList.setSelectedIndices(nArray);
        this.chnList.ensureIndexIsVisible(nArray[nArray.length - 1]);
    }

    @Override
    public void moveSelectedChannelsAtBottom() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0) {
            CC.getLogger().info("Can't move channel(s) at the end");
            return;
        }
        for (int i = 0; i < jSChannelArray.length; ++i) {
            this.listModel.remove(jSChannelArray[i]);
            this.listModel.add(jSChannelArray[i]);
        }
        this.chnList.setSelectionInterval(this.listModel.getSize() - jSChannelArray.length, this.listModel.getSize() - 1);
        this.chnList.ensureIndexIsVisible(this.listModel.getSize() - 1);
    }

    private void scrollToBottom() {
        int n = this.scrollPane.getViewport().getView().getHeight();
        this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(0, n - 2, 1, 1));
    }

    @Override
    public void processChannelSelection(JSChannel jSChannel, boolean bl, boolean bl2) {
    }

    class ContextMenu
    extends MouseAdapter {
        private final JPopupMenu cmenu = new JPopupMenu();
        private final JMenu submenu = new JMenu(ClassicI18n.i18n.getMenuLabel("channels.MoveToTab"));

        ContextMenu() {
            JMenuItem jMenuItem = new JMenuItem(A4n.a4n.moveChannelsOnTop);
            jMenuItem.setIcon(null);
            this.cmenu.add(jMenuItem);
            jMenuItem = new JMenuItem(A4n.a4n.moveChannelsUp);
            jMenuItem.setIcon(null);
            this.cmenu.add(jMenuItem);
            jMenuItem = new JMenuItem(A4n.a4n.moveChannelsDown);
            jMenuItem.setIcon(null);
            this.cmenu.add(jMenuItem);
            jMenuItem = new JMenuItem(A4n.a4n.moveChannelsAtBottom);
            jMenuItem.setIcon(null);
            this.cmenu.add(jMenuItem);
            this.cmenu.add(this.submenu);
            this.cmenu.addSeparator();
            jMenuItem = new JMenuItem(A4n.a4n.removeChannels);
            jMenuItem.setIcon(null);
            this.cmenu.add(jMenuItem);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
        }

        private void updateMenu() {
            this.submenu.removeAll();
            Vector<JSChannelsPane> vector = CC.getMainFrame().getChannelsPaneList();
            for (JSChannelsPane jSChannelsPane : vector) {
                if (jSChannelsPane == CC.getMainFrame().getSelectedChannelsPane()) continue;
                this.submenu.add(new JMenuItem(new A4n.MoveChannelsTo(jSChannelsPane)));
            }
        }
    }
}

