/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public final class MapJavaProxy
extends ConcreteJavaProxy {
    private RubyHashMap wrappedMap;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public MapJavaProxy allocate(Ruby runtime2, RubyClass klazz) {
            return new MapJavaProxy(runtime2, klazz);
        }
    };

    public MapJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public MapJavaProxy(Ruby runtime2, RubyClass klazz, Map map2) {
        super(runtime2, klazz, map2);
    }

    public static RubyClass createMapJavaProxy(Ruby runtime2) {
        RubyClass MapJavaProxy2 = runtime2.defineClass("MapJavaProxy", runtime2.getJavaSupport().getConcreteProxyClass(), ALLOCATOR);
        ConcreteJavaProxy.initialize(MapJavaProxy2);
        return MapJavaProxy2;
    }

    private RubyHashMap getOrCreateRubyHashMap() {
        if (this.wrappedMap == null) {
            this.wrappedMap = new RubyHashMap(this.getRuntime(), this);
        }
        IRubyObject oldExc = this.getRuntime().getGlobalVariables().get("$!");
        try {
            this.wrappedMap.setSize(this.getMapObject().size());
        }
        catch (RaiseException e) {
            this.wrappedMap.setSize(0);
            this.getRuntime().getGlobalVariables().set("$!", oldExc);
        }
        return this.wrappedMap;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        return this.getOrCreateRubyHashMap().default_value_get(context);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        return this.getOrCreateRubyHashMap().default_value_get(context, arg2);
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        return this.getOrCreateRubyHashMap().default_value_set(defaultValue);
    }

    @JRubyMethod(name={"default_proc"})
    public IRubyObject default_proc() {
        return this.getOrCreateRubyHashMap().default_proc();
    }

    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(IRubyObject proc2) {
        return this.getOrCreateRubyHashMap().set_default_proc(proc2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.getOrCreateRubyHashMap().inspect(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getOrCreateRubyHashMap().rb_size();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.getOrCreateRubyHashMap().empty_p();
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getOrCreateRubyHashMap().to_a();
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc(ThreadContext context) {
        IRubyObject newProc = this.getOrCreateRubyHashMap().callMethod("to_proc");
        TypeConverter.checkType(context, newProc, context.runtime.getProc());
        return (RubyProc)newProc;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.getOrCreateRubyHashMap().to_s(context);
    }

    @JRubyMethod(name={"rehash"}, notImplemented=true)
    public RubyHash rehash() {
        return this.getOrCreateRubyHashMap().rehash();
    }

    @JRubyMethod(name={"to_hash", "to_h"})
    public RubyHash to_hash() {
        return this.getOrCreateRubyHashMap().to_hash();
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset(context, key2, value2);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_equal(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_eql(context, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap().op_aref(context, key2);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_lt(context, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_le(context, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_gt(context, other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_ge(context, other);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getOrCreateRubyHashMap().hash();
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap().fetch(context, key2, block);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        return this.getOrCreateRubyHashMap().fetch(context, key2, _default, block);
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap().has_key_p(context, key2);
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().has_value_p(context, expected);
    }

    @JRubyMethod(name={"each", "each_pair"})
    public IRubyObject each(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each(context, block);
    }

    @JRubyMethod(name={"each_value"})
    public IRubyObject each_value(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_value(context, block);
    }

    @JRubyMethod(name={"each_key"})
    public IRubyObject each_key(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_key(context, block);
    }

    @JRubyMethod(name={"select!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select_bang(context, block);
    }

    @JRubyMethod(name={"keep_if"})
    public IRubyObject keep_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().keep_if(context, block);
    }

    @JRubyMethod(name={"index"})
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().index(context, expected);
    }

    @JRubyMethod(name={"key"})
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().key(context, expected);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys(ThreadContext context) {
        return this.getOrCreateRubyHashMap().keys(context);
    }

    @JRubyMethod(name={"values", "ruby_values"})
    public RubyArray rb_values() {
        return this.getOrCreateRubyHashMap().rb_values();
    }

    @JRubyMethod(name={"shift"}, notImplemented=true)
    public IRubyObject shift(ThreadContext context) {
        return this.getOrCreateRubyHashMap().shift(context);
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap().delete(context, key2, block);
    }

    @JRubyMethod(name={"select"})
    public IRubyObject select(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select(context, block);
    }

    @JRubyMethod(name={"delete_if"})
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().delete_if(context, block);
    }

    @JRubyMethod(name={"reject"})
    public IRubyObject reject(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject(context, block);
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject_bang(context, block);
    }

    @JRubyMethod(name={"clear", "ruby_clear"})
    public IRubyObject rb_clear() {
        return this.getOrCreateRubyHashMap().rb_clear();
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        return this.getOrCreateRubyHashMap().invert(context);
    }

    @JRubyMethod(name={"merge!", "update"}, required=1)
    public RubyHash merge_bang(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge_bang(context, other, block);
    }

    @JRubyMethod(name={"merge", "ruby_merge"})
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().initialize_copy(context, other);
    }

    @JRubyMethod(name={"replace", "ruby_replace"}, required=1)
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().replace(context, other);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap().values_at(context, args2);
    }

    @JRubyMethod(name={"fetch_values"}, rest=true)
    public RubyArray fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getOrCreateRubyHashMap().fetch_values(context, args2, block);
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().assoc(context, obj);
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().rassoc(context, obj);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        return this.getOrCreateRubyHashMap().flatten(context);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        return this.getOrCreateRubyHashMap().flatten(context, level2);
    }

    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject compare_by_identity(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return this.getOrCreateRubyHashMap().compare_by_identity_p(context);
    }

    @Override
    public IRubyObject dup() {
        return this.dupImpl("dup");
    }

    @Override
    public IRubyObject rbClone() {
        return this.dupImpl("clone");
    }

    @JRubyMethod(name={"any?"}, optional=1)
    public IRubyObject any_p(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getOrCreateRubyHashMap().any_p(context, args2, block);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap().dig(context, args2);
    }

    private MapJavaProxy dupImpl(String method2) {
        Map map2 = this.getMapObject();
        try {
            Map newMap = (Map)map2.getClass().newInstance();
            newMap.putAll(map2);
            MapJavaProxy proxy2 = new MapJavaProxy(this.getRuntime(), this.metaClass);
            proxy2.setObject(newMap);
            return proxy2;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            RaiseException e = this.getRuntime().newNotImplementedError("can't " + method2 + " Map of type " + this.getObject().getClass().getName());
            e.initCause(ex);
            throw e;
        }
    }

    final Map getMapObject() {
        return (Map)this.getObject();
    }

    @Override
    public final RubyHash convertToHash() {
        return this.getOrCreateRubyHashMap();
    }

    @Deprecated
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset19(context, key2, value2);
    }

    @Deprecated
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().sort(context, block);
    }

    private static final class RubyHashMap
    extends RubyHash {
        static final RubyHash.RubyHashEntry[] EMPTY_TABLE = new RubyHash.RubyHashEntry[0];
        private static final Map.Entry[] NULL_MAP_ENTRY = new Map.Entry[0];
        private final MapJavaProxy receiver;

        RubyHashMap(Ruby runtime2, MapJavaProxy receiver2) {
            super(runtime2, runtime2.getHash(), runtime2.getNil(), EMPTY_TABLE, 0);
            this.receiver = receiver2;
        }

        private void syncSize() {
            this.size = this.mapDelegate().size();
        }

        private void setSize(int size2) {
            this.size = size2;
        }

        private Map mapDelegate() {
            return this.receiver.getMapObject();
        }

        @Override
        public RubyFixnum rb_size() {
            return this.getRuntime().newFixnum(this.mapDelegate().size());
        }

        @Override
        public RubyBoolean empty_p() {
            return this.mapDelegate().isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @Override
        public IRubyObject inspect(ThreadContext context) {
            this.syncSize();
            return super.inspect(context);
        }

        @Override
        public RubyArray to_a() {
            this.syncSize();
            return super.to_a();
        }

        @Override
        public RubyFixnum hash() {
            return this.getRuntime().newFixnum(this.mapDelegate().hashCode());
        }

        @Override
        public RubyArray keys(ThreadContext context) {
            this.syncSize();
            return super.keys(context);
        }

        @Override
        public RubyArray values(ThreadContext context) {
            this.syncSize();
            return super.values(context);
        }

        @Override
        public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
            this.modify();
            Object value2 = this.mapDelegate().remove(key2.toJava(Object.class));
            if (value2 != null) {
                return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2);
            }
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            return context.nil;
        }

        @Override
        public RubyHash delete_ifInternal(ThreadContext context, Block block) {
            RubyHash self2 = super.delete_ifInternal(context, block);
            this.setSize(this.mapDelegate().size());
            return self2;
        }

        @Override
        public void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            this.internalPutNoResize(key2, value2, checkForExisting);
        }

        @Override
        protected final IRubyObject internalPutNoResize(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            Ruby runtime2 = this.getRuntime();
            Map map2 = this.mapDelegate();
            Object javaValue = value2.toJava(Object.class);
            Object existing = map2.put(key2.toJava(Object.class), javaValue);
            this.setSize(map2.size());
            if (existing != null) {
                if (existing == javaValue) {
                    return value2;
                }
                return JavaUtil.convertJavaToUsableRubyObject(runtime2, existing);
            }
            return null;
        }

        @Override
        protected final void op_asetForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
            Map map2 = this.mapDelegate();
            map2.put(key2.decodeString(), value2.toJava(Object.class));
            this.setSize(map2.size());
        }

        @Override
        protected final void op_asetSmallForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
            this.op_asetForString(runtime2, key2, value2);
        }

        @Override
        public IRubyObject internalGet(IRubyObject key2) {
            Object result2 = this.mapDelegate().get(key2.toJava(Object.class));
            if (result2 == null) {
                return null;
            }
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result2);
        }

        @Override
        public RubyHash.RubyHashEntry internalGetEntry(IRubyObject key2) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            Object value2 = map2.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDelete(IRubyObject key2) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            Object value2 = map2.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                map2.remove(convertedKey);
                this.setSize(map2.size());
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDeleteEntry(RubyHash.RubyHashEntry entry) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            if (map2.containsKey(convertedKey = ((IRubyObject)entry.getKey()).toJava(Object.class))) {
                map2.remove(convertedKey);
                this.setSize(map2.size());
                return entry;
            }
            return NO_ENTRY;
        }

        @Override
        public <T> void visitAll(ThreadContext context, RubyHash.VisitorWithState visitor, T state2) {
            Ruby runtime2 = this.getRuntime();
            Map map2 = this.mapDelegate();
            Map.Entry[] entries2 = map2.entrySet().toArray(NULL_MAP_ENTRY);
            int index2 = 0;
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue());
                visitor.visit(context, this, key2, value2, index2++, state2);
            }
        }

        @Override
        public RubyBoolean compare(ThreadContext context, RubyHash.VisitorWithState<RubyHash> method2, IRubyObject other) {
            this.syncSize();
            if (other instanceof RubyHashMap) {
                ((RubyHashMap)other).syncSize();
            }
            return super.compare(context, method2, other);
        }

        @Override
        public RubyBoolean has_key_p(IRubyObject key2) {
            Object convertedKey = key2.toJava(Object.class);
            return this.getRuntime().newBoolean(this.mapDelegate().containsKey(convertedKey));
        }

        @Override
        public RubyBoolean has_value_p(ThreadContext context, IRubyObject val) {
            Object convertedVal = val.toJava(Object.class);
            return this.getRuntime().newBoolean(this.mapDelegate().containsValue(convertedVal));
        }

        @Override
        public RubyHash rehash() {
            return this;
        }

        @Override
        public RubyBoolean compare_by_identity_p(ThreadContext context) {
            return context.runtime.newBoolean(this.mapDelegate() instanceof IdentityHashMap);
        }

        @Override
        public IRubyObject any_p(ThreadContext context, IRubyObject[] args2, Block block) {
            boolean patternGiven;
            boolean bl = patternGiven = args2.length > 0;
            if (this.isEmpty()) {
                return context.fals;
            }
            if (!block.isGiven() && !patternGiven) {
                return context.tru;
            }
            if (patternGiven) {
                return this.any_p_p(context, args2[0]);
            }
            if (block.getSignature().arityValue() > 1) {
                return this.any_p_i_fast(context, block);
            }
            return this.any_p_i(context, block);
        }

        private RubyBoolean any_p_i(ThreadContext context, Block block) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!block.yield(context, RubyArray.newArray(runtime2, key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()))).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        private RubyBoolean any_p_i_fast(ThreadContext context, Block block) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!block.yieldArray(context, runtime2.newArray(key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue())), null).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        private RubyBoolean any_p_p(ThreadContext context, IRubyObject pattern) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!pattern.callMethod(context, "===", RubyArray.newArray(runtime2, key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()))).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        @Override
        public RubyHash rb_clear() {
            this.mapDelegate().clear();
            this.setSize(0);
            return this;
        }

        @Override
        public IRubyObject shift(ThreadContext context) {
            throw this.getRuntime().newNotImplementedError("Java Maps do not preserve insertion order and do not support shift");
        }

        @Override
        public RubyHash to_hash() {
            Ruby runtime2 = this.getRuntime();
            RubyHash hash2 = new RubyHash(runtime2);
            Set entries2 = this.mapDelegate().entrySet();
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue());
                hash2.fastASetCheckString(runtime2, key2, value2);
            }
            return hash2;
        }

        @Override
        public final Set keySet() {
            return this.mapDelegate().keySet();
        }

        @Override
        public final Set directKeySet() {
            return this.keySet();
        }

        @Override
        public final Collection values() {
            return this.mapDelegate().values();
        }

        @Override
        public final Collection directValues() {
            return this.values();
        }

        @Override
        public final Set<Map.Entry> entrySet() {
            return this.mapDelegate().entrySet();
        }

        @Override
        public final Set directEntrySet() {
            return this.entrySet();
        }
    }
}

